package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAssessmentRunsRequest(
    assessmentRunArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest = {
    import DescribeAssessmentRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest
      .builder()
      .assessmentRunArns(assessmentRunArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeAssessmentRunsRequest.ReadOnly =
    zio.aws.inspector.model.DescribeAssessmentRunsRequest.wrap(buildAwsValue())
}
object DescribeAssessmentRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeAssessmentRunsRequest =
      zio.aws.inspector.model.DescribeAssessmentRunsRequest(assessmentRunArns)
    def assessmentRunArns: List[Arn]
    def getAssessmentRunArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(assessmentRunArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest
  ) extends zio.aws.inspector.model.DescribeAssessmentRunsRequest.ReadOnly {
    override val assessmentRunArns: List[Arn] = impl
      .assessmentRunArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest
  ): zio.aws.inspector.model.DescribeAssessmentRunsRequest.ReadOnly =
    new Wrapper(impl)
}
