package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssessmentRunsRequest(
    assessmentTemplateArns: Option[Iterable[Arn]] = None,
    filter: Option[zio.aws.inspector.model.AssessmentRunFilter] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest = {
    import ListAssessmentRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest
      .builder()
      .optionallyWith(
        assessmentTemplateArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.assessmentTemplateArns)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListAssessmentRunsRequest.ReadOnly =
    zio.aws.inspector.model.ListAssessmentRunsRequest.wrap(buildAwsValue())
}
object ListAssessmentRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentRunsRequest =
      zio.aws.inspector.model.ListAssessmentRunsRequest(
        assessmentTemplateArns.map(value => value),
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentTemplateArns: Option[List[Arn]]
    def filter: Option[zio.aws.inspector.model.AssessmentRunFilter.ReadOnly]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListMaxResults]
    def getAssessmentTemplateArns: ZIO[Any, AwsError, List[Arn]] = AwsError
      .unwrapOptionField("assessmentTemplateArns", assessmentTemplateArns)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.inspector.model.AssessmentRunFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest
  ) extends zio.aws.inspector.model.ListAssessmentRunsRequest.ReadOnly {
    override val assessmentTemplateArns: Option[List[Arn]] = scala
      .Option(impl.assessmentTemplateArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector.model.primitives.Arn(item)
        }.toList
      )
    override val filter
        : Option[zio.aws.inspector.model.AssessmentRunFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.inspector.model.AssessmentRunFilter.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest
  ): zio.aws.inspector.model.ListAssessmentRunsRequest.ReadOnly = new Wrapper(
    impl
  )
}
