package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetExclusionsPreviewResponse(
    previewStatus: zio.aws.inspector.model.PreviewStatus,
    exclusionPreviews: Option[
      Iterable[zio.aws.inspector.model.ExclusionPreview]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse = {
    import GetExclusionsPreviewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse
      .builder()
      .previewStatus(previewStatus.unwrap)
      .optionallyWith(
        exclusionPreviews.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exclusionPreviews)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly =
    zio.aws.inspector.model.GetExclusionsPreviewResponse.wrap(buildAwsValue())
}
object GetExclusionsPreviewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.GetExclusionsPreviewResponse =
      zio.aws.inspector.model.GetExclusionsPreviewResponse(
        previewStatus,
        exclusionPreviews.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def previewStatus: zio.aws.inspector.model.PreviewStatus
    def exclusionPreviews
        : Option[List[zio.aws.inspector.model.ExclusionPreview.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getPreviewStatus
        : ZIO[Any, Nothing, zio.aws.inspector.model.PreviewStatus] =
      ZIO.succeed(previewStatus)
    def getExclusionPreviews: ZIO[Any, AwsError, List[
      zio.aws.inspector.model.ExclusionPreview.ReadOnly
    ]] = AwsError.unwrapOptionField("exclusionPreviews", exclusionPreviews)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse
  ) extends zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly {
    override val previewStatus: zio.aws.inspector.model.PreviewStatus =
      zio.aws.inspector.model.PreviewStatus.wrap(impl.previewStatus())
    override val exclusionPreviews
        : Option[List[zio.aws.inspector.model.ExclusionPreview.ReadOnly]] =
      scala
        .Option(impl.exclusionPreviews())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector.model.ExclusionPreview.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse
  ): zio.aws.inspector.model.GetExclusionsPreviewResponse.ReadOnly =
    new Wrapper(impl)
}
