package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListRulesPackagesRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest = {
    import ListRulesPackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.ListRulesPackagesRequest.ReadOnly =
    zio.aws.inspector.model.ListRulesPackagesRequest.wrap(buildAwsValue())
}
object ListRulesPackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListRulesPackagesRequest =
      zio.aws.inspector.model.ListRulesPackagesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListMaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest
  ) extends zio.aws.inspector.model.ListRulesPackagesRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest
  ): zio.aws.inspector.model.ListRulesPackagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
