package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveAttributesFromFindingsResponse(
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse = {
    import RemoveAttributesFromFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse
      .builder()
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly =
    zio.aws.inspector.model.RemoveAttributesFromFindingsResponse
      .wrap(buildAwsValue())
}
object RemoveAttributesFromFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector.model.RemoveAttributesFromFindingsResponse =
      zio.aws.inspector.model
        .RemoveAttributesFromFindingsResponse(failedItems.map({
          case (key, value) =>
            key -> value.asEditable
        }))
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse
  ) extends zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly {
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse
  ): zio.aws.inspector.model.RemoveAttributesFromFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
