package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.ScopeValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Scope(
    key: Option[zio.aws.inspector.model.ScopeType] = None,
    value: Option[ScopeValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.inspector.model.Scope = {
    import Scope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.Scope
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        value.map(value => ScopeValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.Scope.ReadOnly =
    zio.aws.inspector.model.Scope.wrap(buildAwsValue())
}
object Scope {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.inspector.model.Scope] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.Scope = zio.aws.inspector.model
      .Scope(key.map(value => value), value.map(value => value))
    def key: Option[zio.aws.inspector.model.ScopeType]
    def value: Option[ScopeValue]
    def getKey: ZIO[Any, AwsError, zio.aws.inspector.model.ScopeType] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ScopeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.Scope
  ) extends zio.aws.inspector.model.Scope.ReadOnly {
    override val key: Option[zio.aws.inspector.model.ScopeType] = scala
      .Option(impl.key())
      .map(value => zio.aws.inspector.model.ScopeType.wrap(value))
    override val value: Option[ScopeValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.inspector.model.primitives.ScopeValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.Scope
  ): zio.aws.inspector.model.Scope.ReadOnly = new Wrapper(impl)
}
