package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{
  AgentId,
  AutoScalingGroup,
  Hostname,
  Ipv4Address,
  AgentVersion,
  KernelVersion,
  OperatingSystem
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AgentPreview(
    hostname: Option[Hostname] = None,
    agentId: AgentId,
    autoScalingGroup: Option[AutoScalingGroup] = None,
    agentHealth: Option[zio.aws.inspector.model.AgentHealth] = None,
    agentVersion: Option[AgentVersion] = None,
    operatingSystem: Option[OperatingSystem] = None,
    kernelVersion: Option[KernelVersion] = None,
    ipv4Address: Option[Ipv4Address] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AgentPreview = {
    import AgentPreview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AgentPreview
      .builder()
      .optionallyWith(
        hostname.map(value => Hostname.unwrap(value): java.lang.String)
      )(_.hostname)
      .agentId(AgentId.unwrap(agentId): java.lang.String)
      .optionallyWith(
        autoScalingGroup.map(value =>
          AutoScalingGroup.unwrap(value): java.lang.String
        )
      )(_.autoScalingGroup)
      .optionallyWith(agentHealth.map(value => value.unwrap))(_.agentHealth)
      .optionallyWith(
        agentVersion.map(value => AgentVersion.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .optionallyWith(
        operatingSystem.map(value =>
          OperatingSystem.unwrap(value): java.lang.String
        )
      )(_.operatingSystem)
      .optionallyWith(
        kernelVersion.map(value =>
          KernelVersion.unwrap(value): java.lang.String
        )
      )(_.kernelVersion)
      .optionallyWith(
        ipv4Address.map(value => Ipv4Address.unwrap(value): java.lang.String)
      )(_.ipv4Address)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AgentPreview.ReadOnly =
    zio.aws.inspector.model.AgentPreview.wrap(buildAwsValue())
}
object AgentPreview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AgentPreview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AgentPreview =
      zio.aws.inspector.model.AgentPreview(
        hostname.map(value => value),
        agentId,
        autoScalingGroup.map(value => value),
        agentHealth.map(value => value),
        agentVersion.map(value => value),
        operatingSystem.map(value => value),
        kernelVersion.map(value => value),
        ipv4Address.map(value => value)
      )
    def hostname: Option[Hostname]
    def agentId: AgentId
    def autoScalingGroup: Option[AutoScalingGroup]
    def agentHealth: Option[zio.aws.inspector.model.AgentHealth]
    def agentVersion: Option[AgentVersion]
    def operatingSystem: Option[OperatingSystem]
    def kernelVersion: Option[KernelVersion]
    def ipv4Address: Option[Ipv4Address]
    def getHostname: ZIO[Any, AwsError, Hostname] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getAgentId: ZIO[Any, Nothing, AgentId] = ZIO.succeed(agentId)
    def getAutoScalingGroup: ZIO[Any, AwsError, AutoScalingGroup] =
      AwsError.unwrapOptionField("autoScalingGroup", autoScalingGroup)
    def getAgentHealth
        : ZIO[Any, AwsError, zio.aws.inspector.model.AgentHealth] =
      AwsError.unwrapOptionField("agentHealth", agentHealth)
    def getAgentVersion: ZIO[Any, AwsError, AgentVersion] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
    def getOperatingSystem: ZIO[Any, AwsError, OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getKernelVersion: ZIO[Any, AwsError, KernelVersion] =
      AwsError.unwrapOptionField("kernelVersion", kernelVersion)
    def getIpv4Address: ZIO[Any, AwsError, Ipv4Address] =
      AwsError.unwrapOptionField("ipv4Address", ipv4Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AgentPreview
  ) extends zio.aws.inspector.model.AgentPreview.ReadOnly {
    override val hostname: Option[Hostname] = scala
      .Option(impl.hostname())
      .map(value => zio.aws.inspector.model.primitives.Hostname(value))
    override val agentId: AgentId =
      zio.aws.inspector.model.primitives.AgentId(impl.agentId())
    override val autoScalingGroup: Option[AutoScalingGroup] = scala
      .Option(impl.autoScalingGroup())
      .map(value => zio.aws.inspector.model.primitives.AutoScalingGroup(value))
    override val agentHealth: Option[zio.aws.inspector.model.AgentHealth] =
      scala
        .Option(impl.agentHealth())
        .map(value => zio.aws.inspector.model.AgentHealth.wrap(value))
    override val agentVersion: Option[AgentVersion] = scala
      .Option(impl.agentVersion())
      .map(value => zio.aws.inspector.model.primitives.AgentVersion(value))
    override val operatingSystem: Option[OperatingSystem] = scala
      .Option(impl.operatingSystem())
      .map(value => zio.aws.inspector.model.primitives.OperatingSystem(value))
    override val kernelVersion: Option[KernelVersion] = scala
      .Option(impl.kernelVersion())
      .map(value => zio.aws.inspector.model.primitives.KernelVersion(value))
    override val ipv4Address: Option[Ipv4Address] = scala
      .Option(impl.ipv4Address())
      .map(value => zio.aws.inspector.model.primitives.Ipv4Address(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AgentPreview
  ): zio.aws.inspector.model.AgentPreview.ReadOnly = new Wrapper(impl)
}
