package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait InspectorEvent {
  def unwrap: software.amazon.awssdk.services.inspector.model.InspectorEvent
}
object InspectorEvent {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.InspectorEvent
  ): zio.aws.inspector.model.InspectorEvent = value match {
    case software.amazon.awssdk.services.inspector.model.InspectorEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.InspectorEvent.ASSESSMENT_RUN_STARTED =>
      val r = ASSESSMENT_RUN_STARTED
      r
    case software.amazon.awssdk.services.inspector.model.InspectorEvent.ASSESSMENT_RUN_COMPLETED =>
      val r = ASSESSMENT_RUN_COMPLETED
      r
    case software.amazon.awssdk.services.inspector.model.InspectorEvent.ASSESSMENT_RUN_STATE_CHANGED =>
      val r = ASSESSMENT_RUN_STATE_CHANGED
      r
    case software.amazon.awssdk.services.inspector.model.InspectorEvent.FINDING_REPORTED =>
      val r = FINDING_REPORTED
      r
    case software.amazon.awssdk.services.inspector.model.InspectorEvent.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector.model.InspectorEvent {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.InspectorEvent =
      software.amazon.awssdk.services.inspector.model.InspectorEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSESSMENT_RUN_STARTED
      extends zio.aws.inspector.model.InspectorEvent {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.InspectorEvent =
      software.amazon.awssdk.services.inspector.model.InspectorEvent.ASSESSMENT_RUN_STARTED
  }
  case object ASSESSMENT_RUN_COMPLETED
      extends zio.aws.inspector.model.InspectorEvent {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.InspectorEvent =
      software.amazon.awssdk.services.inspector.model.InspectorEvent.ASSESSMENT_RUN_COMPLETED
  }
  case object ASSESSMENT_RUN_STATE_CHANGED
      extends zio.aws.inspector.model.InspectorEvent {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.InspectorEvent =
      software.amazon.awssdk.services.inspector.model.InspectorEvent.ASSESSMENT_RUN_STATE_CHANGED
  }
  case object FINDING_REPORTED extends zio.aws.inspector.model.InspectorEvent {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.InspectorEvent =
      software.amazon.awssdk.services.inspector.model.InspectorEvent.FINDING_REPORTED
  }
  case object OTHER extends zio.aws.inspector.model.InspectorEvent {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.InspectorEvent =
      software.amazon.awssdk.services.inspector.model.InspectorEvent.OTHER
  }
}
