package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAssessmentTemplatesRequest(
    assessmentTemplateArns: Iterable[Arn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest = {
    import DescribeAssessmentTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest
      .builder()
      .assessmentTemplateArns(assessmentTemplateArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeAssessmentTemplatesRequest.ReadOnly =
    zio.aws.inspector.model.DescribeAssessmentTemplatesRequest
      .wrap(buildAwsValue())
}
object DescribeAssessmentTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeAssessmentTemplatesRequest =
      zio.aws.inspector.model
        .DescribeAssessmentTemplatesRequest(assessmentTemplateArns)
    def assessmentTemplateArns: List[Arn]
    def getAssessmentTemplateArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(assessmentTemplateArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest
  ) extends zio.aws.inspector.model.DescribeAssessmentTemplatesRequest.ReadOnly {
    override val assessmentTemplateArns: List[Arn] = impl
      .assessmentTemplateArns()
      .asScala
      .map { item =>
        zio.aws.inspector.model.primitives.Arn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest
  ): zio.aws.inspector.model.DescribeAssessmentTemplatesRequest.ReadOnly =
    new Wrapper(impl)
}
