package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.{AssessmentRunName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartAssessmentRunRequest(
    assessmentTemplateArn: Arn,
    assessmentRunName: Option[AssessmentRunName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest = {
    import StartAssessmentRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest
      .builder()
      .assessmentTemplateArn(
        Arn.unwrap(assessmentTemplateArn): java.lang.String
      )
      .optionallyWith(
        assessmentRunName.map(value =>
          AssessmentRunName.unwrap(value): java.lang.String
        )
      )(_.assessmentRunName)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.StartAssessmentRunRequest.ReadOnly =
    zio.aws.inspector.model.StartAssessmentRunRequest.wrap(buildAwsValue())
}
object StartAssessmentRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.StartAssessmentRunRequest =
      zio.aws.inspector.model.StartAssessmentRunRequest(
        assessmentTemplateArn,
        assessmentRunName.map(value => value)
      )
    def assessmentTemplateArn: Arn
    def assessmentRunName: Option[AssessmentRunName]
    def getAssessmentTemplateArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(assessmentTemplateArn)
    def getAssessmentRunName: ZIO[Any, AwsError, AssessmentRunName] =
      AwsError.unwrapOptionField("assessmentRunName", assessmentRunName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest
  ) extends zio.aws.inspector.model.StartAssessmentRunRequest.ReadOnly {
    override val assessmentTemplateArn: Arn =
      zio.aws.inspector.model.primitives.Arn(impl.assessmentTemplateArn())
    override val assessmentRunName: Option[AssessmentRunName] = scala
      .Option(impl.assessmentRunName())
      .map(value => zio.aws.inspector.model.primitives.AssessmentRunName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest
  ): zio.aws.inspector.model.StartAssessmentRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
