package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait AssetType {
  def unwrap: software.amazon.awssdk.services.inspector.model.AssetType
}
object AssetType {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.AssetType
  ): zio.aws.inspector.model.AssetType = value match {
    case software.amazon.awssdk.services.inspector.model.AssetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.AssetType.EC2_INSTANCE =>
      val r = `ec2-instance`
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssetType =
      software.amazon.awssdk.services.inspector.model.AssetType.UNKNOWN_TO_SDK_VERSION
  }
  case object `ec2-instance` extends zio.aws.inspector.model.AssetType {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.AssetType =
      software.amazon.awssdk.services.inspector.model.AssetType.EC2_INSTANCE
  }
}
