package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{
  ListEventSubscriptionsMaxResults,
  PaginationToken,
  Arn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEventSubscriptionsRequest(
    resourceArn: Option[Arn] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListEventSubscriptionsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest = {
    import ListEventSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
      .builder()
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListEventSubscriptionsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListEventSubscriptionsRequest.ReadOnly =
    zio.aws.inspector.model.ListEventSubscriptionsRequest.wrap(buildAwsValue())
}
object ListEventSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListEventSubscriptionsRequest =
      zio.aws.inspector.model.ListEventSubscriptionsRequest(
        resourceArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceArn: Option[Arn]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListEventSubscriptionsMaxResults]
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListEventSubscriptionsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
  ) extends zio.aws.inspector.model.ListEventSubscriptionsRequest.ReadOnly {
    override val resourceArn: Option[Arn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.inspector.model.primitives.Arn(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListEventSubscriptionsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.inspector.model.primitives
          .ListEventSubscriptionsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest
  ): zio.aws.inspector.model.ListEventSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
