package zio.aws.inspector.model
import java.lang.Integer
import zio.aws.inspector.model.primitives.{ListMaxResults, PaginationToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssessmentTargetsRequest(
    filter: Option[zio.aws.inspector.model.AssessmentTargetFilter] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ListMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest = {
    import ListAssessmentTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.ListAssessmentTargetsRequest.ReadOnly =
    zio.aws.inspector.model.ListAssessmentTargetsRequest.wrap(buildAwsValue())
}
object ListAssessmentTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.ListAssessmentTargetsRequest =
      zio.aws.inspector.model.ListAssessmentTargetsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter: Option[zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly]
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ListMaxResults]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
  ) extends zio.aws.inspector.model.ListAssessmentTargetsRequest.ReadOnly {
    override val filter
        : Option[zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value =>
          zio.aws.inspector.model.AssessmentTargetFilter.wrap(value)
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.inspector.model.primitives.PaginationToken(value))
    override val maxResults: Option[ListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.inspector.model.primitives.ListMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest
  ): zio.aws.inspector.model.ListAssessmentTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
