package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddAttributesToFindingsResponse(
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse = {
    import AddAttributesToFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse
      .builder()
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly =
    zio.aws.inspector.model.AddAttributesToFindingsResponse
      .wrap(buildAwsValue())
}
object AddAttributesToFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AddAttributesToFindingsResponse =
      zio.aws.inspector.model.AddAttributesToFindingsResponse(failedItems.map({
        case (key, value) =>
          key -> value.asEditable
      }))
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse
  ) extends zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly {
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse
  ): zio.aws.inspector.model.AddAttributesToFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
