package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.NamePattern
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssessmentTargetFilter(
    assessmentTargetNamePattern: Option[NamePattern] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.AssessmentTargetFilter = {
    import AssessmentTargetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.AssessmentTargetFilter
      .builder()
      .optionallyWith(
        assessmentTargetNamePattern.map(value =>
          NamePattern.unwrap(value): java.lang.String
        )
      )(_.assessmentTargetNamePattern)
      .build()
  }
  def asReadOnly: zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly =
    zio.aws.inspector.model.AssessmentTargetFilter.wrap(buildAwsValue())
}
object AssessmentTargetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.AssessmentTargetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.AssessmentTargetFilter =
      zio.aws.inspector.model
        .AssessmentTargetFilter(assessmentTargetNamePattern.map(value => value))
    def assessmentTargetNamePattern: Option[NamePattern]
    def getAssessmentTargetNamePattern: ZIO[Any, AwsError, NamePattern] =
      AwsError.unwrapOptionField(
        "assessmentTargetNamePattern",
        assessmentTargetNamePattern
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTargetFilter
  ) extends zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly {
    override val assessmentTargetNamePattern: Option[NamePattern] = scala
      .Option(impl.assessmentTargetNamePattern())
      .map(value => zio.aws.inspector.model.primitives.NamePattern(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.AssessmentTargetFilter
  ): zio.aws.inspector.model.AssessmentTargetFilter.ReadOnly = new Wrapper(impl)
}
