package zio.aws.inspector.model
import scala.jdk.CollectionConverters._
sealed trait FailedItemErrorCode {
  def unwrap
      : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode
}
object FailedItemErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector.model.FailedItemErrorCode
  ): zio.aws.inspector.model.FailedItemErrorCode = value match {
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.INVALID_ARN =>
      val r = INVALID_ARN
      r
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.DUPLICATE_ARN =>
      val r = DUPLICATE_ARN
      r
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.ITEM_DOES_NOT_EXIST =>
      val r = ITEM_DOES_NOT_EXIST
      r
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.LIMIT_EXCEEDED =>
      val r = LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INVALID_ARN extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.INVALID_ARN
  }
  case object DUPLICATE_ARN
      extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.DUPLICATE_ARN
  }
  case object ITEM_DOES_NOT_EXIST
      extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.ITEM_DOES_NOT_EXIST
  }
  case object ACCESS_DENIED
      extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.ACCESS_DENIED
  }
  case object LIMIT_EXCEEDED
      extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.LIMIT_EXCEEDED
  }
  case object INTERNAL_ERROR
      extends zio.aws.inspector.model.FailedItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector.model.FailedItemErrorCode =
      software.amazon.awssdk.services.inspector.model.FailedItemErrorCode.INTERNAL_ERROR
  }
}
