package zio.aws.inspector.model
import zio.aws.inspector.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAssessmentTargetsResponse(
    assessmentTargets: Iterable[zio.aws.inspector.model.AssessmentTarget],
    failedItems: Map[Arn, zio.aws.inspector.model.FailedItemDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse = {
    import DescribeAssessmentTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse
      .builder()
      .assessmentTargets(assessmentTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedItems(
        failedItems
          .map({ case (key, value) =>
            (Arn.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly =
    zio.aws.inspector.model.DescribeAssessmentTargetsResponse
      .wrap(buildAwsValue())
}
object DescribeAssessmentTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector.model.DescribeAssessmentTargetsResponse =
      zio.aws.inspector.model.DescribeAssessmentTargetsResponse(
        assessmentTargets.map { item =>
          item.asEditable
        },
        failedItems.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def assessmentTargets
        : List[zio.aws.inspector.model.AssessmentTarget.ReadOnly]
    def failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly]
    def getAssessmentTargets: ZIO[Any, Nothing, List[
      zio.aws.inspector.model.AssessmentTarget.ReadOnly
    ]] = ZIO.succeed(assessmentTargets)
    def getFailedItems: ZIO[Any, Nothing, Map[
      Arn,
      zio.aws.inspector.model.FailedItemDetails.ReadOnly
    ]] = ZIO.succeed(failedItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse
  ) extends zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly {
    override val assessmentTargets
        : List[zio.aws.inspector.model.AssessmentTarget.ReadOnly] = impl
      .assessmentTargets()
      .asScala
      .map { item =>
        zio.aws.inspector.model.AssessmentTarget.wrap(item)
      }
      .toList
    override val failedItems
        : Map[Arn, zio.aws.inspector.model.FailedItemDetails.ReadOnly] = impl
      .failedItems()
      .asScala
      .map({ case (key, value) =>
        zio.aws.inspector.model.primitives
          .Arn(key) -> zio.aws.inspector.model.FailedItemDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse
  ): zio.aws.inspector.model.DescribeAssessmentTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
