package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TitleAggregation(
    resourceType: Optional[zio.aws.inspector2.model.AggregationResourceType] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.TitleSortBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent,
    titles: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    vulnerabilityIds: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.TitleAggregation = {
    import TitleAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.TitleAggregation
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        titles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.titles)
      .optionallyWith(
        vulnerabilityIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilityIds)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.TitleAggregation.ReadOnly =
    zio.aws.inspector2.model.TitleAggregation.wrap(buildAwsValue())
}
object TitleAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.TitleAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.TitleAggregation =
      zio.aws.inspector2.model.TitleAggregation(
        resourceType.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        titles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerabilityIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceType: Optional[zio.aws.inspector2.model.AggregationResourceType]
    def sortBy: Optional[zio.aws.inspector2.model.TitleSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def titles: Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerabilityIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AggregationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSortBy: ZIO[Any, AwsError, zio.aws.inspector2.model.TitleSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getTitles: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("titles", titles)
    def getVulnerabilityIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilityIds", vulnerabilityIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregation
  ) extends zio.aws.inspector2.model.TitleAggregation.ReadOnly {
    override val resourceType
        : Optional[zio.aws.inspector2.model.AggregationResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.inspector2.model.AggregationResourceType.wrap(value)
        )
    override val sortBy: Optional[zio.aws.inspector2.model.TitleSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.TitleSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
    override val titles
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.titles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val vulnerabilityIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerabilityIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.TitleAggregation
  ): zio.aws.inspector2.model.TitleAggregation.ReadOnly = new Wrapper(impl)
}
