package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ScanType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ScanType
}
object ScanType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ScanType
  ): zio.aws.inspector2.model.ScanType = value match {
    case software.amazon.awssdk.services.inspector2.model.ScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ScanType.NETWORK =>
      val r = NETWORK
      r
    case software.amazon.awssdk.services.inspector2.model.ScanType.PACKAGE =>
      val r = PACKAGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.ScanType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanType =
      software.amazon.awssdk.services.inspector2.model.ScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object NETWORK extends zio.aws.inspector2.model.ScanType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanType =
      software.amazon.awssdk.services.inspector2.model.ScanType.NETWORK
  }
  case object PACKAGE extends zio.aws.inspector2.model.ScanType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanType =
      software.amazon.awssdk.services.inspector2.model.ScanType.PACKAGE
  }
}
