package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters.*
final case class PackageAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    packageName: NonEmptyString,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PackageAggregationResponse = {
    import PackageAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PackageAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .packageName(NonEmptyString.unwrap(packageName): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.PackageAggregationResponse.wrap(buildAwsValue())
}
object PackageAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PackageAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PackageAggregationResponse =
      zio.aws.inspector2.model.PackageAggregationResponse(
        accountId.map(value => value),
        packageName,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def packageName: NonEmptyString
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPackageName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(packageName)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PackageAggregationResponse
  ) extends zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val packageName: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.packageName())
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PackageAggregationResponse
  ): zio.aws.inspector2.model.PackageAggregationResponse.ReadOnly = new Wrapper(
    impl
  )
}
