package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PackageAggregation(
    packageNames: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.PackageSortBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PackageAggregation = {
    import PackageAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PackageAggregation
      .builder()
      .optionallyWith(
        packageNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageNames)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PackageAggregation.ReadOnly =
    zio.aws.inspector2.model.PackageAggregation.wrap(buildAwsValue())
}
object PackageAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PackageAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PackageAggregation =
      zio.aws.inspector2.model.PackageAggregation(
        packageNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def packageNames
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.PackageSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getPackageNames: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("packageNames", packageNames)
    def getSortBy: ZIO[Any, AwsError, zio.aws.inspector2.model.PackageSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PackageAggregation
  ) extends zio.aws.inspector2.model.PackageAggregation.ReadOnly {
    override val packageNames
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy: Optional[zio.aws.inspector2.model.PackageSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.PackageSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PackageAggregation
  ): zio.aws.inspector2.model.PackageAggregation.ReadOnly = new Wrapper(impl)
}
