package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ErrorCode
  ): zio.aws.inspector2.model.ErrorCode = value match {
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.ALREADY_ENABLED =>
      val r = ALREADY_ENABLED
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.ENABLE_IN_PROGRESS =>
      val r = ENABLE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.DISABLE_IN_PROGRESS =>
      val r = DISABLE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.SUSPEND_IN_PROGRESS =>
      val r = SUSPEND_IN_PROGRESS
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.RESOURCE_NOT_FOUND =>
      val r = RESOURCE_NOT_FOUND
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.SSM_UNAVAILABLE =>
      val r = SSM_UNAVAILABLE
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.SSM_THROTTLED =>
      val r = SSM_THROTTLED
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.EVENTBRIDGE_UNAVAILABLE =>
      val r = EVENTBRIDGE_UNAVAILABLE
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.EVENTBRIDGE_THROTTLED =>
      val r = EVENTBRIDGE_THROTTLED
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.RESOURCE_SCAN_NOT_DISABLED =>
      val r = RESOURCE_SCAN_NOT_DISABLED
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.DISASSOCIATE_ALL_MEMBERS =>
      val r = DISASSOCIATE_ALL_MEMBERS
      r
    case software.amazon.awssdk.services.inspector2.model.ErrorCode.ACCOUNT_IS_ISOLATED =>
      val r = ACCOUNT_IS_ISOLATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ALREADY_ENABLED extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.ALREADY_ENABLED
  }
  case object ENABLE_IN_PROGRESS extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.ENABLE_IN_PROGRESS
  }
  case object DISABLE_IN_PROGRESS extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.DISABLE_IN_PROGRESS
  }
  case object SUSPEND_IN_PROGRESS extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.SUSPEND_IN_PROGRESS
  }
  case object RESOURCE_NOT_FOUND extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.RESOURCE_NOT_FOUND
  }
  case object ACCESS_DENIED extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.ACCESS_DENIED
  }
  case object INTERNAL_ERROR extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.INTERNAL_ERROR
  }
  case object SSM_UNAVAILABLE extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.SSM_UNAVAILABLE
  }
  case object SSM_THROTTLED extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.SSM_THROTTLED
  }
  case object EVENTBRIDGE_UNAVAILABLE
      extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.EVENTBRIDGE_UNAVAILABLE
  }
  case object EVENTBRIDGE_THROTTLED extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.EVENTBRIDGE_THROTTLED
  }
  case object RESOURCE_SCAN_NOT_DISABLED
      extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.RESOURCE_SCAN_NOT_DISABLED
  }
  case object DISASSOCIATE_ALL_MEMBERS
      extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.DISASSOCIATE_ALL_MEMBERS
  }
  case object ACCOUNT_IS_ISOLATED extends zio.aws.inspector2.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ErrorCode =
      software.amazon.awssdk.services.inspector2.model.ErrorCode.ACCOUNT_IS_ISOLATED
  }
}
