package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DisableResponse(
    accounts: Iterable[zio.aws.inspector2.model.Account],
    failedAccounts: Optional[Iterable[zio.aws.inspector2.model.FailedAccount]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisableResponse = {
    import DisableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisableResponse
      .builder()
      .accounts(accounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        failedAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedAccounts)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DisableResponse.ReadOnly =
    zio.aws.inspector2.model.DisableResponse.wrap(buildAwsValue())
}
object DisableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DisableResponse =
      zio.aws.inspector2.model.DisableResponse(
        accounts.map { item =>
          item.asEditable
        },
        failedAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accounts: List[zio.aws.inspector2.model.Account.ReadOnly]
    def failedAccounts
        : Optional[List[zio.aws.inspector2.model.FailedAccount.ReadOnly]]
    def getAccounts
        : ZIO[Any, Nothing, List[zio.aws.inspector2.model.Account.ReadOnly]] =
      ZIO.succeed(accounts)
    def getFailedAccounts: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.FailedAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("failedAccounts", failedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisableResponse
  ) extends zio.aws.inspector2.model.DisableResponse.ReadOnly {
    override val accounts: List[zio.aws.inspector2.model.Account.ReadOnly] =
      impl
        .accounts()
        .asScala
        .map { item =>
          zio.aws.inspector2.model.Account.wrap(item)
        }
        .toList
    override val failedAccounts
        : Optional[List[zio.aws.inspector2.model.FailedAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.FailedAccount.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisableResponse
  ): zio.aws.inspector2.model.DisableResponse.ReadOnly = new Wrapper(impl)
}
