package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CoverageFilterCriteria(
    accountId: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    ec2InstanceTags: Optional[
      Iterable[zio.aws.inspector2.model.CoverageMapFilter]
    ] = Optional.Absent,
    ecrImageTags: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    ecrRepositoryName: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    resourceId: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    resourceType: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    scanStatusCode: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    scanStatusReason: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent,
    scanType: Optional[
      Iterable[zio.aws.inspector2.model.CoverageStringFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria = {
    import CoverageFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
      .builder()
      .optionallyWith(
        accountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountId)
      .optionallyWith(
        ec2InstanceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceTags)
      .optionallyWith(
        ecrImageTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageTags)
      .optionallyWith(
        ecrRepositoryName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrRepositoryName)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        scanStatusCode.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanStatusCode)
      .optionallyWith(
        scanStatusReason.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanStatusReason)
      .optionallyWith(
        scanType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scanType)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly =
    zio.aws.inspector2.model.CoverageFilterCriteria.wrap(buildAwsValue())
}
object CoverageFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CoverageFilterCriteria =
      zio.aws.inspector2.model.CoverageFilterCriteria(
        accountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrRepositoryName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanStatusCode.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanStatusReason.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scanType.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def ec2InstanceTags
        : Optional[List[zio.aws.inspector2.model.CoverageMapFilter.ReadOnly]]
    def ecrImageTags
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def ecrRepositoryName
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def resourceId
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def resourceType
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def scanStatusCode
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def scanStatusReason
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def scanType
        : Optional[List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("accountId", accountId)
    def getEc2InstanceTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageMapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceTags", ec2InstanceTags)
    def getEcrImageTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageTags", ecrImageTags)
    def getEcrRepositoryName: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrRepositoryName", ecrRepositoryName)
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getScanStatusCode: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanStatusCode", scanStatusCode)
    def getScanStatusReason: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanStatusReason", scanStatusReason)
    def getScanType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.CoverageStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("scanType", scanType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
  ) extends zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly {
    override val accountId: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val ec2InstanceTags
        : Optional[List[zio.aws.inspector2.model.CoverageMapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.CoverageMapFilter.wrap(item)
          }.toList
        )
    override val ecrImageTags: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrImageTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val ecrRepositoryName: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrRepositoryName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val resourceId: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val resourceType: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val scanStatusCode: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanStatusCode())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val scanStatusReason: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanStatusReason())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
    override val scanType: Optional[
      List[zio.aws.inspector2.model.CoverageStringFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scanType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.CoverageStringFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CoverageFilterCriteria
  ): zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly = new Wrapper(
    impl
  )
}
