package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class BatchGetAccountStatusRequest(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest = {
    import BatchGetAccountStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetAccountStatusRequest.ReadOnly =
    zio.aws.inspector2.model.BatchGetAccountStatusRequest.wrap(buildAwsValue())
}
object BatchGetAccountStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetAccountStatusRequest =
      zio.aws.inspector2.model
        .BatchGetAccountStatusRequest(accountIds.map(value => value))
    def accountIds: Optional[List[AccountId]]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest
  ) extends zio.aws.inspector2.model.BatchGetAccountStatusRequest.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest
  ): zio.aws.inspector2.model.BatchGetAccountStatusRequest.ReadOnly =
    new Wrapper(impl)
}
