package zio.aws.inspector2
import zio.aws.inspector2.model.ListUsageTotalsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.inspector2.{
  Inspector2AsyncClientBuilder,
  Inspector2AsyncClient
}
import software.amazon.awssdk.services.inspector2.model.{
  DelegatedAdminAccount,
  GetDelegatedAdminAccountResponse,
  UpdateFilterRequest,
  CreateFindingsReportResponse,
  CoveredResource,
  GetDelegatedAdminAccountRequest,
  ListDelegatedAdminAccountsRequest,
  Filter,
  ListFindingAggregationsResponse,
  ListFiltersResponse,
  ListAccountPermissionsRequest,
  ListMembersResponse,
  ListMembersRequest,
  UsageTotal,
  DescribeOrganizationConfigurationResponse,
  ListTagsForResourceRequest,
  UpdateConfigurationRequest,
  AggregationResponse,
  UpdateConfigurationResponse,
  BatchGetAccountStatusRequest,
  GetConfigurationResponse,
  EnableResponse,
  ListTagsForResourceResponse,
  ListFindingsResponse,
  CreateFindingsReportRequest,
  UntagResourceResponse,
  DisableDelegatedAdminAccountRequest,
  CreateFilterRequest,
  DisableRequest,
  GetMemberRequest,
  ListFindingsRequest,
  UpdateOrganizationConfigurationRequest,
  ListFiltersRequest,
  BatchGetAccountStatusResponse,
  CreateFilterResponse,
  Permission,
  UpdateFilterResponse,
  ListCoverageResponse,
  UpdateOrganizationConfigurationResponse,
  Counts,
  AssociateMemberRequest,
  ListCoverageStatisticsResponse,
  DisableDelegatedAdminAccountResponse,
  ListDelegatedAdminAccountsResponse,
  CancelFindingsReportResponse,
  CancelFindingsReportRequest,
  ListUsageTotalsResponse,
  UntagResourceRequest,
  DeleteFilterRequest,
  EnableRequest,
  GetFindingsReportStatusRequest,
  GetFindingsReportStatusResponse,
  ListUsageTotalsRequest,
  BatchGetFreeTrialInfoRequest,
  AssociateMemberResponse,
  DisassociateMemberRequest,
  GetConfigurationRequest,
  DeleteFilterResponse,
  DescribeOrganizationConfigurationRequest,
  BatchGetFreeTrialInfoResponse,
  Finding,
  TagResourceResponse,
  DisableResponse,
  EnableDelegatedAdminAccountResponse,
  GetMemberResponse,
  ListAccountPermissionsResponse,
  Member,
  ListCoverageRequest,
  TagResourceRequest,
  ListCoverageStatisticsRequest,
  DisassociateMemberResponse,
  EnableDelegatedAdminAccountRequest,
  ListFindingAggregationsRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.inspector2.paginators.{
  ListFiltersPublisher,
  ListMembersPublisher,
  ListAccountPermissionsPublisher,
  ListCoveragePublisher,
  ListCoverageStatisticsPublisher,
  ListUsageTotalsPublisher,
  ListFindingAggregationsPublisher,
  ListFindingsPublisher,
  ListDelegatedAdminAccountsPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Inspector2 extends AspectSupport[Inspector2] {
  val api: Inspector2AsyncClient
  def enable(
      request: zio.aws.inspector2.model.EnableRequest
  ): IO[AwsError, zio.aws.inspector2.model.EnableResponse.ReadOnly]
  def listFindings(
      request: zio.aws.inspector2.model.ListFindingsRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.Finding.ReadOnly]
  def listFindingsPaginated(
      request: zio.aws.inspector2.model.ListFindingsRequest
  ): IO[AwsError, zio.aws.inspector2.model.ListFindingsResponse.ReadOnly]
  def enableDelegatedAdminAccount(
      request: zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly
  ]
  def listCoverage(
      request: zio.aws.inspector2.model.ListCoverageRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.CoveredResource.ReadOnly]
  def listCoveragePaginated(
      request: zio.aws.inspector2.model.ListCoverageRequest
  ): IO[AwsError, zio.aws.inspector2.model.ListCoverageResponse.ReadOnly]
  def disable(
      request: zio.aws.inspector2.model.DisableRequest
  ): IO[AwsError, zio.aws.inspector2.model.DisableResponse.ReadOnly]
  def updateConfiguration(
      request: zio.aws.inspector2.model.UpdateConfigurationRequest
  ): IO[AwsError, zio.aws.inspector2.model.UpdateConfigurationResponse.ReadOnly]
  def updateOrganizationConfiguration(
      request: zio.aws.inspector2.model.UpdateOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ]
  def deleteFilter(
      request: zio.aws.inspector2.model.DeleteFilterRequest
  ): IO[AwsError, zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly]
  def disassociateMember(
      request: zio.aws.inspector2.model.DisassociateMemberRequest
  ): IO[AwsError, zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly]
  def disableDelegatedAdminAccount(
      request: zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly
  ]
  def createFilter(
      request: zio.aws.inspector2.model.CreateFilterRequest
  ): IO[AwsError, zio.aws.inspector2.model.CreateFilterResponse.ReadOnly]
  def listMembers(
      request: zio.aws.inspector2.model.ListMembersRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.Member.ReadOnly]
  def listMembersPaginated(
      request: zio.aws.inspector2.model.ListMembersRequest
  ): IO[AwsError, zio.aws.inspector2.model.ListMembersResponse.ReadOnly]
  def listFindingAggregations(
      request: zio.aws.inspector2.model.ListFindingAggregationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.inspector2.model.AggregationResponse.ReadOnly
  ]
  def listFindingAggregationsPaginated(
      request: zio.aws.inspector2.model.ListFindingAggregationsRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly
  ]
  def cancelFindingsReport(
      request: zio.aws.inspector2.model.CancelFindingsReportRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.inspector2.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.inspector2.model.UntagResourceResponse.ReadOnly]
  def listDelegatedAdminAccounts(
      request: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly
  ]
  def listDelegatedAdminAccountsPaginated(
      request: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly
  ]
  def getMember(
      request: zio.aws.inspector2.model.GetMemberRequest
  ): IO[AwsError, zio.aws.inspector2.model.GetMemberResponse.ReadOnly]
  def listFilters(
      request: zio.aws.inspector2.model.ListFiltersRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.Filter.ReadOnly]
  def listFiltersPaginated(
      request: zio.aws.inspector2.model.ListFiltersRequest
  ): IO[AwsError, zio.aws.inspector2.model.ListFiltersResponse.ReadOnly]
  def describeOrganizationConfiguration(
      request: zio.aws.inspector2.model.DescribeOrganizationConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.inspector2.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly]
  def associateMember(
      request: zio.aws.inspector2.model.AssociateMemberRequest
  ): IO[AwsError, zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly]
  def tagResource(
      request: zio.aws.inspector2.model.TagResourceRequest
  ): IO[AwsError, zio.aws.inspector2.model.TagResourceResponse.ReadOnly]
  def createFindingsReport(
      request: zio.aws.inspector2.model.CreateFindingsReportRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.CreateFindingsReportResponse.ReadOnly
  ]
  def getConfiguration(
      request: zio.aws.inspector2.model.GetConfigurationRequest
  ): IO[AwsError, zio.aws.inspector2.model.GetConfigurationResponse.ReadOnly]
  def batchGetAccountStatus(
      request: zio.aws.inspector2.model.BatchGetAccountStatusRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly
  ]
  def getDelegatedAdminAccount(
      request: zio.aws.inspector2.model.GetDelegatedAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly
  ]
  def batchGetFreeTrialInfo(
      request: zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly
  ]
  def updateFilter(
      request: zio.aws.inspector2.model.UpdateFilterRequest
  ): IO[AwsError, zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly]
  def getFindingsReportStatus(
      request: zio.aws.inspector2.model.GetFindingsReportStatusRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly
  ]
  def listAccountPermissions(
      request: zio.aws.inspector2.model.ListAccountPermissionsRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.Permission.ReadOnly]
  def listAccountPermissionsPaginated(
      request: zio.aws.inspector2.model.ListAccountPermissionsRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly
  ]
  def listCoverageStatistics(
      request: zio.aws.inspector2.model.ListCoverageStatisticsRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.Counts.ReadOnly]
  def listCoverageStatisticsPaginated(
      request: zio.aws.inspector2.model.ListCoverageStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly
  ]
  def listUsageTotals(
      request: zio.aws.inspector2.model.ListUsageTotalsRequest
  ): ZStream[Any, AwsError, zio.aws.inspector2.model.UsageTotal.ReadOnly]
  def listUsageTotalsPaginated(
      request: zio.aws.inspector2.model.ListUsageTotalsRequest
  ): IO[AwsError, ReadOnly]
}
object Inspector2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Inspector2] = customized(
    identity
  )
  def customized(
      customization: Inspector2AsyncClientBuilder => Inspector2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Inspector2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Inspector2AsyncClientBuilder => Inspector2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Inspector2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Inspector2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[Inspector2AsyncClient, Inspector2AsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[Inspector2AsyncClient, Inspector2AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new Inspector2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class Inspector2Impl[R](
      override val api: Inspector2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Inspector2
      with AwsServiceBase[R] {
    override val serviceName: String = "Inspector2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Inspector2Impl[R1] = new Inspector2Impl(api, newAspect, r)
    def enable(
        request: zio.aws.inspector2.model.EnableRequest
    ): IO[AwsError, zio.aws.inspector2.model.EnableResponse.ReadOnly] =
      asyncRequestResponse[EnableRequest, EnableResponse]("enable", api.enable)(
        request.buildAwsValue()
      ).map(zio.aws.inspector2.model.EnableResponse.wrap).provideEnvironment(r)
    def listFindings(
        request: zio.aws.inspector2.model.ListFindingsRequest
    ): ZStream[Any, AwsError, zio.aws.inspector2.model.Finding.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListFindingsRequest,
        Finding,
        ListFindingsPublisher
      ]("listFindings", api.listFindingsPaginator, _.findings())(
        request.buildAwsValue()
      ).map(item => zio.aws.inspector2.model.Finding.wrap(item))
        .provideEnvironment(r)
    def listFindingsPaginated(
        request: zio.aws.inspector2.model.ListFindingsRequest
    ): IO[AwsError, zio.aws.inspector2.model.ListFindingsResponse.ReadOnly] =
      asyncRequestResponse[ListFindingsRequest, ListFindingsResponse](
        "listFindings",
        api.listFindings
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.ListFindingsResponse.wrap)
        .provideEnvironment(r)
    def enableDelegatedAdminAccount(
        request: zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableDelegatedAdminAccountRequest,
      EnableDelegatedAdminAccountResponse
    ]("enableDelegatedAdminAccount", api.enableDelegatedAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def listCoverage(
        request: zio.aws.inspector2.model.ListCoverageRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.inspector2.model.CoveredResource.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListCoverageRequest,
      CoveredResource,
      ListCoveragePublisher
    ]("listCoverage", api.listCoveragePaginator, _.coveredResources())(
      request.buildAwsValue()
    ).map(item => zio.aws.inspector2.model.CoveredResource.wrap(item))
      .provideEnvironment(r)
    def listCoveragePaginated(
        request: zio.aws.inspector2.model.ListCoverageRequest
    ): IO[AwsError, zio.aws.inspector2.model.ListCoverageResponse.ReadOnly] =
      asyncRequestResponse[ListCoverageRequest, ListCoverageResponse](
        "listCoverage",
        api.listCoverage
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.ListCoverageResponse.wrap)
        .provideEnvironment(r)
    def disable(
        request: zio.aws.inspector2.model.DisableRequest
    ): IO[AwsError, zio.aws.inspector2.model.DisableResponse.ReadOnly] =
      asyncRequestResponse[DisableRequest, DisableResponse](
        "disable",
        api.disable
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.DisableResponse.wrap)
        .provideEnvironment(r)
    def updateConfiguration(
        request: zio.aws.inspector2.model.UpdateConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.UpdateConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateConfigurationRequest,
      UpdateConfigurationResponse
    ]("updateConfiguration", api.updateConfiguration)(request.buildAwsValue())
      .map(zio.aws.inspector2.model.UpdateConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateOrganizationConfiguration(
        request: zio.aws.inspector2.model.UpdateOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.UpdateOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateOrganizationConfigurationRequest,
      UpdateOrganizationConfigurationResponse
    ]("updateOrganizationConfiguration", api.updateOrganizationConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.UpdateOrganizationConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteFilter(
        request: zio.aws.inspector2.model.DeleteFilterRequest
    ): IO[AwsError, zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly] =
      asyncRequestResponse[DeleteFilterRequest, DeleteFilterResponse](
        "deleteFilter",
        api.deleteFilter
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.DeleteFilterResponse.wrap)
        .provideEnvironment(r)
    def disassociateMember(
        request: zio.aws.inspector2.model.DisassociateMemberRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMemberRequest,
      DisassociateMemberResponse
    ]("disassociateMember", api.disassociateMember)(request.buildAwsValue())
      .map(zio.aws.inspector2.model.DisassociateMemberResponse.wrap)
      .provideEnvironment(r)
    def disableDelegatedAdminAccount(
        request: zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableDelegatedAdminAccountRequest,
      DisableDelegatedAdminAccountResponse
    ]("disableDelegatedAdminAccount", api.disableDelegatedAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def createFilter(
        request: zio.aws.inspector2.model.CreateFilterRequest
    ): IO[AwsError, zio.aws.inspector2.model.CreateFilterResponse.ReadOnly] =
      asyncRequestResponse[CreateFilterRequest, CreateFilterResponse](
        "createFilter",
        api.createFilter
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.CreateFilterResponse.wrap)
        .provideEnvironment(r)
    def listMembers(
        request: zio.aws.inspector2.model.ListMembersRequest
    ): ZStream[Any, AwsError, zio.aws.inspector2.model.Member.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListMembersRequest,
        Member,
        ListMembersPublisher
      ]("listMembers", api.listMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.inspector2.model.Member.wrap(item))
        .provideEnvironment(r)
    def listMembersPaginated(
        request: zio.aws.inspector2.model.ListMembersRequest
    ): IO[AwsError, zio.aws.inspector2.model.ListMembersResponse.ReadOnly] =
      asyncRequestResponse[ListMembersRequest, ListMembersResponse](
        "listMembers",
        api.listMembers
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.ListMembersResponse.wrap)
        .provideEnvironment(r)
    def listFindingAggregations(
        request: zio.aws.inspector2.model.ListFindingAggregationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.inspector2.model.AggregationResponse.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListFindingAggregationsRequest,
      AggregationResponse,
      ListFindingAggregationsPublisher
    ](
      "listFindingAggregations",
      api.listFindingAggregationsPaginator,
      _.responses()
    )(request.buildAwsValue())
      .map(item => zio.aws.inspector2.model.AggregationResponse.wrap(item))
      .provideEnvironment(r)
    def listFindingAggregationsPaginated(
        request: zio.aws.inspector2.model.ListFindingAggregationsRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListFindingAggregationsRequest,
      ListFindingAggregationsResponse
    ]("listFindingAggregations", api.listFindingAggregations)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.ListFindingAggregationsResponse.wrap)
      .provideEnvironment(r)
    def cancelFindingsReport(
        request: zio.aws.inspector2.model.CancelFindingsReportRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelFindingsReportRequest,
      CancelFindingsReportResponse
    ]("cancelFindingsReport", api.cancelFindingsReport)(request.buildAwsValue())
      .map(zio.aws.inspector2.model.CancelFindingsReportResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.inspector2.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.inspector2.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listDelegatedAdminAccounts(
        request: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListDelegatedAdminAccountsRequest,
      DelegatedAdminAccount,
      ListDelegatedAdminAccountsPublisher
    ](
      "listDelegatedAdminAccounts",
      api.listDelegatedAdminAccountsPaginator,
      _.delegatedAdminAccounts()
    )(request.buildAwsValue())
      .map(item => zio.aws.inspector2.model.DelegatedAdminAccount.wrap(item))
      .provideEnvironment(r)
    def listDelegatedAdminAccountsPaginated(
        request: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDelegatedAdminAccountsRequest,
      ListDelegatedAdminAccountsResponse
    ]("listDelegatedAdminAccounts", api.listDelegatedAdminAccounts)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.wrap)
      .provideEnvironment(r)
    def getMember(
        request: zio.aws.inspector2.model.GetMemberRequest
    ): IO[AwsError, zio.aws.inspector2.model.GetMemberResponse.ReadOnly] =
      asyncRequestResponse[GetMemberRequest, GetMemberResponse](
        "getMember",
        api.getMember
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.GetMemberResponse.wrap)
        .provideEnvironment(r)
    def listFilters(
        request: zio.aws.inspector2.model.ListFiltersRequest
    ): ZStream[Any, AwsError, zio.aws.inspector2.model.Filter.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListFiltersRequest,
        Filter,
        ListFiltersPublisher
      ]("listFilters", api.listFiltersPaginator, _.filters())(
        request.buildAwsValue()
      ).map(item => zio.aws.inspector2.model.Filter.wrap(item))
        .provideEnvironment(r)
    def listFiltersPaginated(
        request: zio.aws.inspector2.model.ListFiltersRequest
    ): IO[AwsError, zio.aws.inspector2.model.ListFiltersResponse.ReadOnly] =
      asyncRequestResponse[ListFiltersRequest, ListFiltersResponse](
        "listFilters",
        api.listFilters
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.ListFiltersResponse.wrap)
        .provideEnvironment(r)
    def describeOrganizationConfiguration(
        request: zio.aws.inspector2.model.DescribeOrganizationConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrganizationConfigurationRequest,
      DescribeOrganizationConfigurationResponse
    ](
      "describeOrganizationConfiguration",
      api.describeOrganizationConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.inspector2.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.inspector2.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def associateMember(
        request: zio.aws.inspector2.model.AssociateMemberRequest
    ): IO[AwsError, zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly] =
      asyncRequestResponse[AssociateMemberRequest, AssociateMemberResponse](
        "associateMember",
        api.associateMember
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.AssociateMemberResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.inspector2.model.TagResourceRequest
    ): IO[AwsError, zio.aws.inspector2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createFindingsReport(
        request: zio.aws.inspector2.model.CreateFindingsReportRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.CreateFindingsReportResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateFindingsReportRequest,
      CreateFindingsReportResponse
    ]("createFindingsReport", api.createFindingsReport)(request.buildAwsValue())
      .map(zio.aws.inspector2.model.CreateFindingsReportResponse.wrap)
      .provideEnvironment(r)
    def getConfiguration(
        request: zio.aws.inspector2.model.GetConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.GetConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[GetConfigurationRequest, GetConfigurationResponse](
      "getConfiguration",
      api.getConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.inspector2.model.GetConfigurationResponse.wrap)
      .provideEnvironment(r)
    def batchGetAccountStatus(
        request: zio.aws.inspector2.model.BatchGetAccountStatusRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetAccountStatusRequest,
      BatchGetAccountStatusResponse
    ]("batchGetAccountStatus", api.batchGetAccountStatus)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.BatchGetAccountStatusResponse.wrap)
      .provideEnvironment(r)
    def getDelegatedAdminAccount(
        request: zio.aws.inspector2.model.GetDelegatedAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDelegatedAdminAccountRequest,
      GetDelegatedAdminAccountResponse
    ]("getDelegatedAdminAccount", api.getDelegatedAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def batchGetFreeTrialInfo(
        request: zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetFreeTrialInfoRequest,
      BatchGetFreeTrialInfoResponse
    ]("batchGetFreeTrialInfo", api.batchGetFreeTrialInfo)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.wrap)
      .provideEnvironment(r)
    def updateFilter(
        request: zio.aws.inspector2.model.UpdateFilterRequest
    ): IO[AwsError, zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly] =
      asyncRequestResponse[UpdateFilterRequest, UpdateFilterResponse](
        "updateFilter",
        api.updateFilter
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.UpdateFilterResponse.wrap)
        .provideEnvironment(r)
    def getFindingsReportStatus(
        request: zio.aws.inspector2.model.GetFindingsReportStatusRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetFindingsReportStatusRequest,
      GetFindingsReportStatusResponse
    ]("getFindingsReportStatus", api.getFindingsReportStatus)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.GetFindingsReportStatusResponse.wrap)
      .provideEnvironment(r)
    def listAccountPermissions(
        request: zio.aws.inspector2.model.ListAccountPermissionsRequest
    ): ZStream[Any, AwsError, zio.aws.inspector2.model.Permission.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListAccountPermissionsRequest,
        Permission,
        ListAccountPermissionsPublisher
      ](
        "listAccountPermissions",
        api.listAccountPermissionsPaginator,
        _.permissions()
      )(request.buildAwsValue())
        .map(item => zio.aws.inspector2.model.Permission.wrap(item))
        .provideEnvironment(r)
    def listAccountPermissionsPaginated(
        request: zio.aws.inspector2.model.ListAccountPermissionsRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAccountPermissionsRequest,
      ListAccountPermissionsResponse
    ]("listAccountPermissions", api.listAccountPermissions)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.ListAccountPermissionsResponse.wrap)
      .provideEnvironment(r)
    def listCoverageStatistics(
        request: zio.aws.inspector2.model.ListCoverageStatisticsRequest
    ): ZStream[Any, AwsError, zio.aws.inspector2.model.Counts.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListCoverageStatisticsRequest,
        Counts,
        ListCoverageStatisticsPublisher
      ](
        "listCoverageStatistics",
        api.listCoverageStatisticsPaginator,
        _.countsByGroup()
      )(request.buildAwsValue())
        .map(item => zio.aws.inspector2.model.Counts.wrap(item))
        .provideEnvironment(r)
    def listCoverageStatisticsPaginated(
        request: zio.aws.inspector2.model.ListCoverageStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCoverageStatisticsRequest,
      ListCoverageStatisticsResponse
    ]("listCoverageStatistics", api.listCoverageStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.inspector2.model.ListCoverageStatisticsResponse.wrap)
      .provideEnvironment(r)
    def listUsageTotals(
        request: zio.aws.inspector2.model.ListUsageTotalsRequest
    ): ZStream[Any, AwsError, zio.aws.inspector2.model.UsageTotal.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListUsageTotalsRequest,
        UsageTotal,
        ListUsageTotalsPublisher
      ]("listUsageTotals", api.listUsageTotalsPaginator, _.totals())(
        request.buildAwsValue()
      ).map(item => zio.aws.inspector2.model.UsageTotal.wrap(item))
        .provideEnvironment(r)
    def listUsageTotalsPaginated(
        request: zio.aws.inspector2.model.ListUsageTotalsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListUsageTotalsRequest, ListUsageTotalsResponse](
        "listUsageTotals",
        api.listUsageTotals
      )(request.buildAwsValue())
        .map(zio.aws.inspector2.model.ListUsageTotalsResponse.wrap)
        .provideEnvironment(r)
  }
  def enable(request: zio.aws.inspector2.model.EnableRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.EnableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enable(request))
  def listFindings(
      request: zio.aws.inspector2.model.ListFindingsRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.Finding.ReadOnly
  ] = ZStream.serviceWithStream(_.listFindings(request))
  def listFindingsPaginated(
      request: zio.aws.inspector2.model.ListFindingsRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsPaginated(request))
  def enableDelegatedAdminAccount(
      request: zio.aws.inspector2.model.EnableDelegatedAdminAccountRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.EnableDelegatedAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableDelegatedAdminAccount(request))
  def listCoverage(
      request: zio.aws.inspector2.model.ListCoverageRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.CoveredResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listCoverage(request))
  def listCoveragePaginated(
      request: zio.aws.inspector2.model.ListCoverageRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListCoverageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCoveragePaginated(request))
  def disable(request: zio.aws.inspector2.model.DisableRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.DisableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disable(request))
  def updateConfiguration(
      request: zio.aws.inspector2.model.UpdateConfigurationRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.UpdateConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfiguration(request))
  def updateOrganizationConfiguration(
      request: zio.aws.inspector2.model.UpdateOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.UpdateOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOrganizationConfiguration(request))
  def deleteFilter(request: zio.aws.inspector2.model.DeleteFilterRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.DeleteFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFilter(request))
  def disassociateMember(
      request: zio.aws.inspector2.model.DisassociateMemberRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.DisassociateMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMember(request))
  def disableDelegatedAdminAccount(
      request: zio.aws.inspector2.model.DisableDelegatedAdminAccountRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.DisableDelegatedAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableDelegatedAdminAccount(request))
  def createFilter(request: zio.aws.inspector2.model.CreateFilterRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.CreateFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFilter(request))
  def listMembers(
      request: zio.aws.inspector2.model.ListMembersRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.Member.ReadOnly
  ] = ZStream.serviceWithStream(_.listMembers(request))
  def listMembersPaginated(
      request: zio.aws.inspector2.model.ListMembersRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMembersPaginated(request))
  def listFindingAggregations(
      request: zio.aws.inspector2.model.ListFindingAggregationsRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.AggregationResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.listFindingAggregations(request))
  def listFindingAggregationsPaginated(
      request: zio.aws.inspector2.model.ListFindingAggregationsRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListFindingAggregationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingAggregationsPaginated(request))
  def cancelFindingsReport(
      request: zio.aws.inspector2.model.CancelFindingsReportRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.CancelFindingsReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelFindingsReport(request))
  def untagResource(
      request: zio.aws.inspector2.model.UntagResourceRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listDelegatedAdminAccounts(
      request: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.DelegatedAdminAccount.ReadOnly
  ] = ZStream.serviceWithStream(_.listDelegatedAdminAccounts(request))
  def listDelegatedAdminAccountsPaginated(
      request: zio.aws.inspector2.model.ListDelegatedAdminAccountsRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListDelegatedAdminAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDelegatedAdminAccountsPaginated(request))
  def getMember(request: zio.aws.inspector2.model.GetMemberRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.GetMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMember(request))
  def listFilters(
      request: zio.aws.inspector2.model.ListFiltersRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.Filter.ReadOnly
  ] = ZStream.serviceWithStream(_.listFilters(request))
  def listFiltersPaginated(
      request: zio.aws.inspector2.model.ListFiltersRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFiltersPaginated(request))
  def describeOrganizationConfiguration(
      request: zio.aws.inspector2.model.DescribeOrganizationConfigurationRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.DescribeOrganizationConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationConfiguration(request))
  def listTagsForResource(
      request: zio.aws.inspector2.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def associateMember(
      request: zio.aws.inspector2.model.AssociateMemberRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.AssociateMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMember(request))
  def tagResource(request: zio.aws.inspector2.model.TagResourceRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createFindingsReport(
      request: zio.aws.inspector2.model.CreateFindingsReportRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.CreateFindingsReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFindingsReport(request))
  def getConfiguration(
      request: zio.aws.inspector2.model.GetConfigurationRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.GetConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfiguration(request))
  def batchGetAccountStatus(
      request: zio.aws.inspector2.model.BatchGetAccountStatusRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.BatchGetAccountStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetAccountStatus(request))
  def getDelegatedAdminAccount(
      request: zio.aws.inspector2.model.GetDelegatedAdminAccountRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.GetDelegatedAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDelegatedAdminAccount(request))
  def batchGetFreeTrialInfo(
      request: zio.aws.inspector2.model.BatchGetFreeTrialInfoRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetFreeTrialInfo(request))
  def updateFilter(request: zio.aws.inspector2.model.UpdateFilterRequest): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.UpdateFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFilter(request))
  def getFindingsReportStatus(
      request: zio.aws.inspector2.model.GetFindingsReportStatusRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.GetFindingsReportStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsReportStatus(request))
  def listAccountPermissions(
      request: zio.aws.inspector2.model.ListAccountPermissionsRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.Permission.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccountPermissions(request))
  def listAccountPermissionsPaginated(
      request: zio.aws.inspector2.model.ListAccountPermissionsRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListAccountPermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccountPermissionsPaginated(request))
  def listCoverageStatistics(
      request: zio.aws.inspector2.model.ListCoverageStatisticsRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.Counts.ReadOnly
  ] = ZStream.serviceWithStream(_.listCoverageStatistics(request))
  def listCoverageStatisticsPaginated(
      request: zio.aws.inspector2.model.ListCoverageStatisticsRequest
  ): ZIO[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.ListCoverageStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCoverageStatisticsPaginated(request))
  def listUsageTotals(
      request: zio.aws.inspector2.model.ListUsageTotalsRequest
  ): ZStream[
    zio.aws.inspector2.Inspector2,
    AwsError,
    zio.aws.inspector2.model.UsageTotal.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsageTotals(request))
  def listUsageTotalsPaginated(
      request: zio.aws.inspector2.model.ListUsageTotalsRequest
  ): ZIO[zio.aws.inspector2.Inspector2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listUsageTotalsPaginated(request))
}
