package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NumberFilter(
    lowerInclusive: Optional[Double] = Optional.Absent,
    upperInclusive: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.NumberFilter = {
    import NumberFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.NumberFilter
      .builder()
      .optionallyWith(lowerInclusive.map(value => value: java.lang.Double))(
        _.lowerInclusive
      )
      .optionallyWith(upperInclusive.map(value => value: java.lang.Double))(
        _.upperInclusive
      )
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.NumberFilter.ReadOnly =
    zio.aws.inspector2.model.NumberFilter.wrap(buildAwsValue())
}
object NumberFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.NumberFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.NumberFilter =
      zio.aws.inspector2.model.NumberFilter(
        lowerInclusive.map(value => value),
        upperInclusive.map(value => value)
      )
    def lowerInclusive: Optional[Double]
    def upperInclusive: Optional[Double]
    def getLowerInclusive: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("lowerInclusive", lowerInclusive)
    def getUpperInclusive: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("upperInclusive", upperInclusive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.NumberFilter
  ) extends zio.aws.inspector2.model.NumberFilter.ReadOnly {
    override val lowerInclusive: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.lowerInclusive())
      .map(value => value: Double)
    override val upperInclusive: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.upperInclusive())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.NumberFilter
  ): zio.aws.inspector2.model.NumberFilter.ReadOnly = new Wrapper(impl)
}
