package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FindingTypeAggregation(
    findingType: Optional[zio.aws.inspector2.model.AggregationFindingType] =
      Optional.Absent,
    resourceType: Optional[zio.aws.inspector2.model.AggregationResourceType] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.FindingTypeSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation = {
    import FindingTypeAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation
      .builder()
      .optionallyWith(findingType.map(value => value.unwrap))(_.findingType)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly =
    zio.aws.inspector2.model.FindingTypeAggregation.wrap(buildAwsValue())
}
object FindingTypeAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FindingTypeAggregation =
      zio.aws.inspector2.model.FindingTypeAggregation(
        findingType.map(value => value),
        resourceType.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def findingType: Optional[zio.aws.inspector2.model.AggregationFindingType]
    def resourceType: Optional[zio.aws.inspector2.model.AggregationResourceType]
    def sortBy: Optional[zio.aws.inspector2.model.FindingTypeSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getFindingType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AggregationFindingType] =
      AwsError.unwrapOptionField("findingType", findingType)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AggregationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.FindingTypeSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation
  ) extends zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly {
    override val findingType
        : Optional[zio.aws.inspector2.model.AggregationFindingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingType())
        .map(value =>
          zio.aws.inspector2.model.AggregationFindingType.wrap(value)
        )
    override val resourceType
        : Optional[zio.aws.inspector2.model.AggregationResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.inspector2.model.AggregationResourceType.wrap(value)
        )
    override val sortBy: Optional[zio.aws.inspector2.model.FindingTypeSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.FindingTypeSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation
  ): zio.aws.inspector2.model.FindingTypeAggregation.ReadOnly = new Wrapper(
    impl
  )
}
