package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait FindingType {
  def unwrap: software.amazon.awssdk.services.inspector2.model.FindingType
}
object FindingType {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FindingType
  ): zio.aws.inspector2.model.FindingType = value match {
    case software.amazon.awssdk.services.inspector2.model.FindingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FindingType.NETWORK_REACHABILITY =>
      val r = NETWORK_REACHABILITY
      r
    case software.amazon.awssdk.services.inspector2.model.FindingType.PACKAGE_VULNERABILITY =>
      val r = PACKAGE_VULNERABILITY
      r
  }
  case object unknownToSdkVersion extends zio.aws.inspector2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingType =
      software.amazon.awssdk.services.inspector2.model.FindingType.UNKNOWN_TO_SDK_VERSION
  }
  case object NETWORK_REACHABILITY
      extends zio.aws.inspector2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingType =
      software.amazon.awssdk.services.inspector2.model.FindingType.NETWORK_REACHABILITY
  }
  case object PACKAGE_VULNERABILITY
      extends zio.aws.inspector2.model.FindingType {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingType =
      software.amazon.awssdk.services.inspector2.model.FindingType.PACKAGE_VULNERABILITY
  }
}
