package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Ec2InstanceAggregation(
    amis: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    instanceIds: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    instanceTags: Optional[Iterable[zio.aws.inspector2.model.MapFilter]] =
      Optional.Absent,
    operatingSystems: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.Ec2InstanceSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation = {
    import Ec2InstanceAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation
      .builder()
      .optionallyWith(
        amis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.amis)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        instanceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTags)
      .optionallyWith(
        operatingSystems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operatingSystems)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly =
    zio.aws.inspector2.model.Ec2InstanceAggregation.wrap(buildAwsValue())
}
object Ec2InstanceAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Ec2InstanceAggregation =
      zio.aws.inspector2.model.Ec2InstanceAggregation(
        amis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operatingSystems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def amis: Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def instanceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def instanceTags
        : Optional[List[zio.aws.inspector2.model.MapFilter.ReadOnly]]
    def operatingSystems
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.Ec2InstanceSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getAmis: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("amis", amis)
    def getInstanceIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getInstanceTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTags", instanceTags)
    def getOperatingSystems: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("operatingSystems", operatingSystems)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.Ec2InstanceSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation
  ) extends zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly {
    override val amis
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amis())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val instanceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val instanceTags
        : Optional[List[zio.aws.inspector2.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.MapFilter.wrap(item)
          }.toList
        )
    override val operatingSystems
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy: Optional[zio.aws.inspector2.model.Ec2InstanceSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.inspector2.model.Ec2InstanceSortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation
  ): zio.aws.inspector2.model.Ec2InstanceAggregation.ReadOnly = new Wrapper(
    impl
  )
}
