package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class DisableRequest(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    resourceTypes: Optional[
      Iterable[zio.aws.inspector2.model.ResourceScanType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.DisableRequest = {
    import DisableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.DisableRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.DisableRequest.ReadOnly =
    zio.aws.inspector2.model.DisableRequest.wrap(buildAwsValue())
}
object DisableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.DisableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.DisableRequest =
      zio.aws.inspector2.model.DisableRequest(
        accountIds.map(value => value),
        resourceTypes.map(value => value)
      )
    def accountIds: Optional[List[AccountId]]
    def resourceTypes: Optional[List[zio.aws.inspector2.model.ResourceScanType]]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.ResourceScanType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.DisableRequest
  ) extends zio.aws.inspector2.model.DisableRequest.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.inspector2.model.primitives.AccountId(item)
        }.toList
      )
    override val resourceTypes
        : Optional[List[zio.aws.inspector2.model.ResourceScanType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.ResourceScanType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.DisableRequest
  ): zio.aws.inspector2.model.DisableRequest.ReadOnly = new Wrapper(impl)
}
