package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.inspector2.model.primitives.ReportId
import scala.jdk.CollectionConverters.*
final case class CancelFindingsReportRequest(reportId: ReportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest = {
    import CancelFindingsReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.CancelFindingsReportRequest.ReadOnly =
    zio.aws.inspector2.model.CancelFindingsReportRequest.wrap(buildAwsValue())
}
object CancelFindingsReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.CancelFindingsReportRequest =
      zio.aws.inspector2.model.CancelFindingsReportRequest(reportId)
    def reportId: ReportId
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest
  ) extends zio.aws.inspector2.model.CancelFindingsReportRequest.ReadOnly {
    override val reportId: ReportId =
      zio.aws.inspector2.model.primitives.ReportId(impl.reportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest
  ): zio.aws.inspector2.model.CancelFindingsReportRequest.ReadOnly =
    new Wrapper(impl)
}
