package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait StringComparison {
  def unwrap: software.amazon.awssdk.services.inspector2.model.StringComparison
}
object StringComparison {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.StringComparison
  ): zio.aws.inspector2.model.StringComparison = value match {
    case software.amazon.awssdk.services.inspector2.model.StringComparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.StringComparison.EQUALS =>
      val r = EQUALS
      r
    case software.amazon.awssdk.services.inspector2.model.StringComparison.PREFIX =>
      val r = PREFIX
      r
    case software.amazon.awssdk.services.inspector2.model.StringComparison.NOT_EQUALS =>
      val r = NOT_EQUALS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.StringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StringComparison =
      software.amazon.awssdk.services.inspector2.model.StringComparison.UNKNOWN_TO_SDK_VERSION
  }
  case object EQUALS extends zio.aws.inspector2.model.StringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StringComparison =
      software.amazon.awssdk.services.inspector2.model.StringComparison.EQUALS
  }
  case object PREFIX extends zio.aws.inspector2.model.StringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StringComparison =
      software.amazon.awssdk.services.inspector2.model.StringComparison.PREFIX
  }
  case object NOT_EQUALS extends zio.aws.inspector2.model.StringComparison {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.StringComparison =
      software.amazon.awssdk.services.inspector2.model.StringComparison.NOT_EQUALS
  }
}
