package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ScanStatusReason {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ScanStatusReason
}
object ScanStatusReason {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ScanStatusReason
  ): zio.aws.inspector2.model.ScanStatusReason = value match {
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.PENDING_INITIAL_SCAN =>
      val r = PENDING_INITIAL_SCAN
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.UNMANAGED_EC2_INSTANCE =>
      val r = UNMANAGED_EC2_INSTANCE
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.UNSUPPORTED_OS =>
      val r = UNSUPPORTED_OS
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SCAN_ELIGIBILITY_EXPIRED =>
      val r = SCAN_ELIGIBILITY_EXPIRED
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.RESOURCE_TERMINATED =>
      val r = RESOURCE_TERMINATED
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SUCCESSFUL =>
      val r = SUCCESSFUL
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.NO_RESOURCES_FOUND =>
      val r = NO_RESOURCES_FOUND
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.IMAGE_SIZE_EXCEEDED =>
      val r = IMAGE_SIZE_EXCEEDED
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SCAN_FREQUENCY_MANUAL =>
      val r = SCAN_FREQUENCY_MANUAL
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SCAN_FREQUENCY_SCAN_ON_PUSH =>
      val r = SCAN_FREQUENCY_SCAN_ON_PUSH
      r
    case software.amazon.awssdk.services.inspector2.model.ScanStatusReason.EC2_INSTANCE_STOPPED =>
      val r = EC2_INSTANCE_STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_INITIAL_SCAN
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.PENDING_INITIAL_SCAN
  }
  case object ACCESS_DENIED extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.ACCESS_DENIED
  }
  case object INTERNAL_ERROR extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.INTERNAL_ERROR
  }
  case object UNMANAGED_EC2_INSTANCE
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.UNMANAGED_EC2_INSTANCE
  }
  case object UNSUPPORTED_OS extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.UNSUPPORTED_OS
  }
  case object SCAN_ELIGIBILITY_EXPIRED
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SCAN_ELIGIBILITY_EXPIRED
  }
  case object RESOURCE_TERMINATED
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.RESOURCE_TERMINATED
  }
  case object SUCCESSFUL extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SUCCESSFUL
  }
  case object NO_RESOURCES_FOUND
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.NO_RESOURCES_FOUND
  }
  case object IMAGE_SIZE_EXCEEDED
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.IMAGE_SIZE_EXCEEDED
  }
  case object SCAN_FREQUENCY_MANUAL
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SCAN_FREQUENCY_MANUAL
  }
  case object SCAN_FREQUENCY_SCAN_ON_PUSH
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.SCAN_FREQUENCY_SCAN_ON_PUSH
  }
  case object EC2_INSTANCE_STOPPED
      extends zio.aws.inspector2.model.ScanStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ScanStatusReason =
      software.amazon.awssdk.services.inspector2.model.ScanStatusReason.EC2_INSTANCE_STOPPED
  }
}
