package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{NextToken, ListCoverageMaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListCoverageRequest(
    filterCriteria: Optional[zio.aws.inspector2.model.CoverageFilterCriteria] =
      Optional.Absent,
    maxResults: Optional[ListCoverageMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ListCoverageRequest = {
    import ListCoverageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ListCoverageRequest
      .builder()
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maxResults.map(value => ListCoverageMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ListCoverageRequest.ReadOnly =
    zio.aws.inspector2.model.ListCoverageRequest.wrap(buildAwsValue())
}
object ListCoverageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ListCoverageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ListCoverageRequest =
      zio.aws.inspector2.model.ListCoverageRequest(
        filterCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filterCriteria
        : Optional[zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly]
    def maxResults: Optional[ListCoverageMaxResults]
    def nextToken: Optional[NextToken]
    def getFilterCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaxResults: ZIO[Any, AwsError, ListCoverageMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageRequest
  ) extends zio.aws.inspector2.model.ListCoverageRequest.ReadOnly {
    override val filterCriteria
        : Optional[zio.aws.inspector2.model.CoverageFilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value =>
          zio.aws.inspector2.model.CoverageFilterCriteria.wrap(value)
        )
    override val maxResults: Optional[ListCoverageMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.inspector2.model.primitives.ListCoverageMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.inspector2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ListCoverageRequest
  ): zio.aws.inspector2.model.ListCoverageRequest.ReadOnly = new Wrapper(impl)
}
