package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait FindingStatus {
  def unwrap: software.amazon.awssdk.services.inspector2.model.FindingStatus
}
object FindingStatus {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.FindingStatus
  ): zio.aws.inspector2.model.FindingStatus = value match {
    case software.amazon.awssdk.services.inspector2.model.FindingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.FindingStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.inspector2.model.FindingStatus.SUPPRESSED =>
      val r = SUPPRESSED
      r
    case software.amazon.awssdk.services.inspector2.model.FindingStatus.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingStatus =
      software.amazon.awssdk.services.inspector2.model.FindingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.inspector2.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingStatus =
      software.amazon.awssdk.services.inspector2.model.FindingStatus.ACTIVE
  }
  case object SUPPRESSED extends zio.aws.inspector2.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingStatus =
      software.amazon.awssdk.services.inspector2.model.FindingStatus.SUPPRESSED
  }
  case object CLOSED extends zio.aws.inspector2.model.FindingStatus {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.FindingStatus =
      software.amazon.awssdk.services.inspector2.model.FindingStatus.CLOSED
  }
}
