package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilterCriteria(
    awsAccountId: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    componentId: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    componentType: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    ec2InstanceImageId: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    ec2InstanceSubnetId: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    ec2InstanceVpcId: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    ecrImageArchitecture: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    ecrImageHash: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    ecrImagePushedAt: Optional[Iterable[zio.aws.inspector2.model.DateFilter]] =
      Optional.Absent,
    ecrImageRegistry: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    ecrImageRepositoryName: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    ecrImageTags: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    findingArn: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    findingStatus: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    findingType: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    firstObservedAt: Optional[Iterable[zio.aws.inspector2.model.DateFilter]] =
      Optional.Absent,
    inspectorScore: Optional[Iterable[zio.aws.inspector2.model.NumberFilter]] =
      Optional.Absent,
    lastObservedAt: Optional[Iterable[zio.aws.inspector2.model.DateFilter]] =
      Optional.Absent,
    networkProtocol: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    portRange: Optional[Iterable[zio.aws.inspector2.model.PortRangeFilter]] =
      Optional.Absent,
    relatedVulnerabilities: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    resourceId: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.inspector2.model.MapFilter]] =
      Optional.Absent,
    resourceType: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    severity: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    title: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    updatedAt: Optional[Iterable[zio.aws.inspector2.model.DateFilter]] =
      Optional.Absent,
    vendorSeverity: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    vulnerabilityId: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    vulnerabilitySource: Optional[
      Iterable[zio.aws.inspector2.model.StringFilter]
    ] = Optional.Absent,
    vulnerablePackages: Optional[
      Iterable[zio.aws.inspector2.model.PackageFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FilterCriteria = {
    import FilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FilterCriteria
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccountId)
      .optionallyWith(
        componentId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.componentId)
      .optionallyWith(
        componentType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.componentType)
      .optionallyWith(
        ec2InstanceImageId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceImageId)
      .optionallyWith(
        ec2InstanceSubnetId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceSubnetId)
      .optionallyWith(
        ec2InstanceVpcId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2InstanceVpcId)
      .optionallyWith(
        ecrImageArchitecture.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageArchitecture)
      .optionallyWith(
        ecrImageHash.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageHash)
      .optionallyWith(
        ecrImagePushedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImagePushedAt)
      .optionallyWith(
        ecrImageRegistry.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageRegistry)
      .optionallyWith(
        ecrImageRepositoryName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageRepositoryName)
      .optionallyWith(
        ecrImageTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecrImageTags)
      .optionallyWith(
        findingArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingArn)
      .optionallyWith(
        findingStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingStatus)
      .optionallyWith(
        findingType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingType)
      .optionallyWith(
        firstObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firstObservedAt)
      .optionallyWith(
        inspectorScore.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inspectorScore)
      .optionallyWith(
        lastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastObservedAt)
      .optionallyWith(
        networkProtocol.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProtocol)
      .optionallyWith(
        portRange.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRange)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        severity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severity)
      .optionallyWith(
        title.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.title)
      .optionallyWith(
        updatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updatedAt)
      .optionallyWith(
        vendorSeverity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vendorSeverity)
      .optionallyWith(
        vulnerabilityId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilityId)
      .optionallyWith(
        vulnerabilitySource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerabilitySource)
      .optionallyWith(
        vulnerablePackages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vulnerablePackages)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FilterCriteria.ReadOnly =
    zio.aws.inspector2.model.FilterCriteria.wrap(buildAwsValue())
}
object FilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FilterCriteria =
      zio.aws.inspector2.model.FilterCriteria(
        awsAccountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        componentId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        componentType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceImageId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceSubnetId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2InstanceVpcId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageArchitecture.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageHash.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImagePushedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageRegistry.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageRepositoryName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ecrImageTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firstObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inspectorScore.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkProtocol.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        portRange.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedVulnerabilities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        title.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vendorSeverity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerabilityId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerabilitySource.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vulnerablePackages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccountId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def componentId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def componentType
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ec2InstanceImageId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ec2InstanceSubnetId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ec2InstanceVpcId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageArchitecture
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageHash
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImagePushedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def ecrImageRegistry
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageRepositoryName
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def ecrImageTags
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def findingArn
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def findingStatus
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def findingType
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def firstObservedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def inspectorScore
        : Optional[List[zio.aws.inspector2.model.NumberFilter.ReadOnly]]
    def lastObservedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def networkProtocol
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def portRange
        : Optional[List[zio.aws.inspector2.model.PortRangeFilter.ReadOnly]]
    def relatedVulnerabilities
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceTags
        : Optional[List[zio.aws.inspector2.model.MapFilter.ReadOnly]]
    def resourceType
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def severity: Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def title: Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def updatedAt: Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]]
    def vendorSeverity
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerabilityId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerabilitySource
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def vulnerablePackages
        : Optional[List[zio.aws.inspector2.model.PackageFilter.ReadOnly]]
    def getAwsAccountId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getComponentId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("componentId", componentId)
    def getComponentType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("componentType", componentType)
    def getEc2InstanceImageId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceImageId", ec2InstanceImageId)
    def getEc2InstanceSubnetId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceSubnetId", ec2InstanceSubnetId)
    def getEc2InstanceVpcId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2InstanceVpcId", ec2InstanceVpcId)
    def getEcrImageArchitecture: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("ecrImageArchitecture", ecrImageArchitecture)
    def getEcrImageHash: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageHash", ecrImageHash)
    def getEcrImagePushedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImagePushedAt", ecrImagePushedAt)
    def getEcrImageRegistry: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageRegistry", ecrImageRegistry)
    def getEcrImageRepositoryName: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ecrImageRepositoryName",
      ecrImageRepositoryName
    )
    def getEcrImageTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ecrImageTags", ecrImageTags)
    def getFindingArn: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingArn", findingArn)
    def getFindingStatus: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingStatus", findingStatus)
    def getFindingType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("findingType", findingType)
    def getFirstObservedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getInspectorScore: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("inspectorScore", inspectorScore)
    def getLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getNetworkProtocol: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProtocol", networkProtocol)
    def getPortRange: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.PortRangeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("portRange", portRange)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relatedVulnerabilities",
      relatedVulnerabilities
    )
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getSeverity: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severity", severity)
    def getTitle: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("title", title)
    def getUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getVendorSeverity: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vendorSeverity", vendorSeverity)
    def getVulnerabilityId: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilityId", vulnerabilityId)
    def getVulnerabilitySource: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerabilitySource", vulnerabilitySource)
    def getVulnerablePackages: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.PackageFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("vulnerablePackages", vulnerablePackages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FilterCriteria
  ) extends zio.aws.inspector2.model.FilterCriteria.ReadOnly {
    override val awsAccountId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val componentId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val componentType
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ec2InstanceImageId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceImageId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ec2InstanceSubnetId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceSubnetId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ec2InstanceVpcId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceVpcId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ecrImageArchitecture
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrImageArchitecture())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ecrImageHash
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrImageHash())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ecrImagePushedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrImagePushedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.DateFilter.wrap(item)
          }.toList
        )
    override val ecrImageRegistry
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrImageRegistry())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ecrImageRepositoryName
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrImageRepositoryName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val ecrImageTags
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrImageTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingArn
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingArn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingStatus
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val findingType
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val firstObservedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.DateFilter.wrap(item)
          }.toList
        )
    override val inspectorScore
        : Optional[List[zio.aws.inspector2.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inspectorScore())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.NumberFilter.wrap(item)
          }.toList
        )
    override val lastObservedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.DateFilter.wrap(item)
          }.toList
        )
    override val networkProtocol
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProtocol())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val portRange
        : Optional[List[zio.aws.inspector2.model.PortRangeFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRange())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.PortRangeFilter.wrap(item)
          }.toList
        )
    override val relatedVulnerabilities
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedVulnerabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceTags
        : Optional[List[zio.aws.inspector2.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.MapFilter.wrap(item)
          }.toList
        )
    override val resourceType
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val severity
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val title
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.title())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val updatedAt
        : Optional[List[zio.aws.inspector2.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.DateFilter.wrap(item)
          }.toList
        )
    override val vendorSeverity
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorSeverity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val vulnerabilityId
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerabilityId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val vulnerabilitySource
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerabilitySource())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val vulnerablePackages
        : Optional[List[zio.aws.inspector2.model.PackageFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerablePackages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.PackageFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FilterCriteria
  ): zio.aws.inspector2.model.FilterCriteria.ReadOnly = new Wrapper(impl)
}
