package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.{NonEmptyString, AccountId}
import scala.jdk.CollectionConverters.*
final case class AwsEcrContainerAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    architecture: Optional[String] = Optional.Absent,
    imageSha: Optional[String] = Optional.Absent,
    imageTags: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    repository: Optional[String] = Optional.Absent,
    resourceId: NonEmptyString,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse = {
    import AwsEcrContainerAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(imageSha.map(value => value: java.lang.String))(
        _.imageSha
      )
      .optionallyWith(
        imageTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageTags)
      .optionallyWith(repository.map(value => value: java.lang.String))(
        _.repository
      )
      .resourceId(NonEmptyString.unwrap(resourceId): java.lang.String)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.AwsEcrContainerAggregationResponse
      .wrap(buildAwsValue())
}
object AwsEcrContainerAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.inspector2.model.AwsEcrContainerAggregationResponse =
      zio.aws.inspector2.model.AwsEcrContainerAggregationResponse(
        accountId.map(value => value),
        architecture.map(value => value),
        imageSha.map(value => value),
        imageTags.map(value => value),
        repository.map(value => value),
        resourceId,
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def architecture: Optional[String]
    def imageSha: Optional[String]
    def imageTags: Optional[List[NonEmptyString]]
    def repository: Optional[String]
    def resourceId: NonEmptyString
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getImageSha: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageSha", imageSha)
    def getImageTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("imageTags", imageTags)
    def getRepository: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("repository", repository)
    def getResourceId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(resourceId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
  ) extends zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val architecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => value: String)
    override val imageSha: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageSha())
      .map(value => value: String)
    override val imageTags: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val repository: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.repository())
      .map(value => value: String)
    override val resourceId: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.resourceId())
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregationResponse
  ): zio.aws.inspector2.model.AwsEcrContainerAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
