package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsEcrContainerAggregation(
    architectures: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    imageShas: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    imageTags: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    repositories: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    resourceIds: Optional[Iterable[zio.aws.inspector2.model.StringFilter]] =
      Optional.Absent,
    sortBy: Optional[zio.aws.inspector2.model.AwsEcrContainerSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.inspector2.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation = {
    import AwsEcrContainerAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation
      .builder()
      .optionallyWith(
        architectures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.architectures)
      .optionallyWith(
        imageShas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageShas)
      .optionallyWith(
        imageTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageTags)
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly =
    zio.aws.inspector2.model.AwsEcrContainerAggregation.wrap(buildAwsValue())
}
object AwsEcrContainerAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AwsEcrContainerAggregation =
      zio.aws.inspector2.model.AwsEcrContainerAggregation(
        architectures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageShas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def architectures
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def imageShas
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def imageTags
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def repositories
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]]
    def sortBy: Optional[zio.aws.inspector2.model.AwsEcrContainerSortBy]
    def sortOrder: Optional[zio.aws.inspector2.model.SortOrder]
    def getArchitectures: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("architectures", architectures)
    def getImageShas: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("imageShas", imageShas)
    def getImageTags: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("imageTags", imageTags)
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getResourceIds: ZIO[Any, AwsError, List[
      zio.aws.inspector2.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.inspector2.model.AwsEcrContainerSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.inspector2.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation
  ) extends zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly {
    override val architectures
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architectures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val imageShas
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageShas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val imageTags
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val repositories
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceIds
        : Optional[List[zio.aws.inspector2.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.StringFilter.wrap(item)
          }.toList
        )
    override val sortBy
        : Optional[zio.aws.inspector2.model.AwsEcrContainerSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.inspector2.model.AwsEcrContainerSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.inspector2.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.inspector2.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation
  ): zio.aws.inspector2.model.AwsEcrContainerAggregation.ReadOnly = new Wrapper(
    impl
  )
}
