package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AutoEnable(ec2: Boolean, ecr: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AutoEnable = {
    import AutoEnable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AutoEnable
      .builder()
      .ec2(ec2: java.lang.Boolean)
      .ecr(ecr: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.AutoEnable.ReadOnly =
    zio.aws.inspector2.model.AutoEnable.wrap(buildAwsValue())
}
object AutoEnable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AutoEnable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AutoEnable =
      zio.aws.inspector2.model.AutoEnable(ec2, ecr)
    def ec2: Boolean
    def ecr: Boolean
    def getEc2: ZIO[Any, Nothing, Boolean] = ZIO.succeed(ec2)
    def getEcr: ZIO[Any, Nothing, Boolean] = ZIO.succeed(ecr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AutoEnable
  ) extends zio.aws.inspector2.model.AutoEnable.ReadOnly {
    override val ec2: Boolean = impl.ec2(): Boolean
    override val ecr: Boolean = impl.ecr(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AutoEnable
  ): zio.aws.inspector2.model.AutoEnable.ReadOnly = new Wrapper(impl)
}
