package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.MeteringAccountId
import scala.jdk.CollectionConverters.*
final case class UsageTotal(
    accountId: Optional[MeteringAccountId] = Optional.Absent,
    usage: Optional[Iterable[zio.aws.inspector2.model.Usage]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.UsageTotal = {
    import UsageTotal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.UsageTotal
      .builder()
      .optionallyWith(
        accountId.map(value =>
          MeteringAccountId.unwrap(value): java.lang.String
        )
      )(_.accountId)
      .optionallyWith(
        usage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usage)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.UsageTotal.ReadOnly =
    zio.aws.inspector2.model.UsageTotal.wrap(buildAwsValue())
}
object UsageTotal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.UsageTotal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.UsageTotal =
      zio.aws.inspector2.model.UsageTotal(
        accountId.map(value => value),
        usage.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def accountId: Optional[MeteringAccountId]
    def usage: Optional[List[zio.aws.inspector2.model.Usage.ReadOnly]]
    def getAccountId: ZIO[Any, AwsError, MeteringAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getUsage
        : ZIO[Any, AwsError, List[zio.aws.inspector2.model.Usage.ReadOnly]] =
      AwsError.unwrapOptionField("usage", usage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.UsageTotal
  ) extends zio.aws.inspector2.model.UsageTotal.ReadOnly {
    override val accountId: Optional[MeteringAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.inspector2.model.primitives.MeteringAccountId(value)
      )
    override val usage
        : Optional[List[zio.aws.inspector2.model.Usage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.Usage.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.UsageTotal
  ): zio.aws.inspector2.model.UsageTotal.ReadOnly = new Wrapper(impl)
}
