package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResourceState(
    ec2: zio.aws.inspector2.model.State,
    ecr: zio.aws.inspector2.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.ResourceState = {
    import ResourceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.ResourceState
      .builder()
      .ec2(ec2.buildAwsValue())
      .ecr(ecr.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.ResourceState.ReadOnly =
    zio.aws.inspector2.model.ResourceState.wrap(buildAwsValue())
}
object ResourceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.ResourceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.ResourceState =
      zio.aws.inspector2.model.ResourceState(ec2.asEditable, ecr.asEditable)
    def ec2: zio.aws.inspector2.model.State.ReadOnly
    def ecr: zio.aws.inspector2.model.State.ReadOnly
    def getEc2: ZIO[Any, Nothing, zio.aws.inspector2.model.State.ReadOnly] =
      ZIO.succeed(ec2)
    def getEcr: ZIO[Any, Nothing, zio.aws.inspector2.model.State.ReadOnly] =
      ZIO.succeed(ecr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceState
  ) extends zio.aws.inspector2.model.ResourceState.ReadOnly {
    override val ec2: zio.aws.inspector2.model.State.ReadOnly =
      zio.aws.inspector2.model.State.wrap(impl.ec2())
    override val ecr: zio.aws.inspector2.model.State.ReadOnly =
      zio.aws.inspector2.model.State.wrap(impl.ecr())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.ResourceState
  ): zio.aws.inspector2.model.ResourceState.ReadOnly = new Wrapper(impl)
}
