package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait ImageLayerSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy
}
object ImageLayerSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy
  ): zio.aws.inspector2.model.ImageLayerSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.ImageLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.inspector2.model.ImageLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.ImageLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.ImageLayerSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy =
      software.amazon.awssdk.services.inspector2.model.ImageLayerSortBy.ALL
  }
}
