package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.inspector2.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class FindingTypeAggregationResponse(
    accountId: Optional[AccountId] = Optional.Absent,
    severityCounts: Optional[zio.aws.inspector2.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse = {
    import FindingTypeAggregationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly =
    zio.aws.inspector2.model.FindingTypeAggregationResponse
      .wrap(buildAwsValue())
}
object FindingTypeAggregationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FindingTypeAggregationResponse =
      zio.aws.inspector2.model.FindingTypeAggregationResponse(
        accountId.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSeverityCounts
        : ZIO[Any, AwsError, zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
  ) extends zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.inspector2.model.primitives.AccountId(value))
    override val severityCounts
        : Optional[zio.aws.inspector2.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.inspector2.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FindingTypeAggregationResponse
  ): zio.aws.inspector2.model.FindingTypeAggregationResponse.ReadOnly =
    new Wrapper(impl)
}
