package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Destination(
    bucketName: String,
    keyPrefix: Optional[String] = Optional.Absent,
    kmsKeyArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.Destination
      .builder()
      .bucketName(bucketName: java.lang.String)
      .optionallyWith(keyPrefix.map(value => value: java.lang.String))(
        _.keyPrefix
      )
      .kmsKeyArn(kmsKeyArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.Destination.ReadOnly =
    zio.aws.inspector2.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.Destination =
      zio.aws.inspector2.model
        .Destination(bucketName, keyPrefix.map(value => value), kmsKeyArn)
    def bucketName: String
    def keyPrefix: Optional[String]
    def kmsKeyArn: String
    def getBucketName: ZIO[Any, Nothing, String] = ZIO.succeed(bucketName)
    def getKeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
    def getKmsKeyArn: ZIO[Any, Nothing, String] = ZIO.succeed(kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.Destination
  ) extends zio.aws.inspector2.model.Destination.ReadOnly {
    override val bucketName: String = impl.bucketName(): String
    override val keyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPrefix())
      .map(value => value: String)
    override val kmsKeyArn: String = impl.kmsKeyArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.Destination
  ): zio.aws.inspector2.model.Destination.ReadOnly = new Wrapper(impl)
}
