package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetFreeTrialInfoResponse(
    accounts: Iterable[zio.aws.inspector2.model.FreeTrialAccountInfo],
    failedAccounts: Iterable[zio.aws.inspector2.model.FreeTrialInfoError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse = {
    import BatchGetFreeTrialInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse
      .builder()
      .accounts(accounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .failedAccounts(failedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly =
    zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.wrap(buildAwsValue())
}
object BatchGetFreeTrialInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse =
      zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse(
        accounts.map { item =>
          item.asEditable
        },
        failedAccounts.map { item =>
          item.asEditable
        }
      )
    def accounts: List[zio.aws.inspector2.model.FreeTrialAccountInfo.ReadOnly]
    def failedAccounts
        : List[zio.aws.inspector2.model.FreeTrialInfoError.ReadOnly]
    def getAccounts: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.FreeTrialAccountInfo.ReadOnly
    ]] = ZIO.succeed(accounts)
    def getFailedAccounts: ZIO[Any, Nothing, List[
      zio.aws.inspector2.model.FreeTrialInfoError.ReadOnly
    ]] = ZIO.succeed(failedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse
  ) extends zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly {
    override val accounts
        : List[zio.aws.inspector2.model.FreeTrialAccountInfo.ReadOnly] = impl
      .accounts()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.FreeTrialAccountInfo.wrap(item)
      }
      .toList
    override val failedAccounts
        : List[zio.aws.inspector2.model.FreeTrialInfoError.ReadOnly] = impl
      .failedAccounts()
      .asScala
      .map { item =>
        zio.aws.inspector2.model.FreeTrialInfoError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse
  ): zio.aws.inspector2.model.BatchGetFreeTrialInfoResponse.ReadOnly =
    new Wrapper(impl)
}
