package zio.aws.inspector2.model
import zio.aws.inspector2.model.primitives.{
  DateTimeTimestamp,
  Platform,
  ImageHash,
  NonEmptyString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AwsEcrContainerImageDetails(
    architecture: Optional[NonEmptyString] = Optional.Absent,
    author: Optional[String] = Optional.Absent,
    imageHash: ImageHash,
    imageTags: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    platform: Optional[Platform] = Optional.Absent,
    pushedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    registry: NonEmptyString,
    repositoryName: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.AwsEcrContainerImageDetails = {
    import AwsEcrContainerImageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerImageDetails
      .builder()
      .optionallyWith(
        architecture.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.architecture)
      .optionallyWith(author.map(value => value: java.lang.String))(_.author)
      .imageHash(ImageHash.unwrap(imageHash): java.lang.String)
      .optionallyWith(
        imageTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageTags)
      .optionallyWith(
        platform.map(value => Platform.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        pushedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.pushedAt)
      .registry(NonEmptyString.unwrap(registry): java.lang.String)
      .repositoryName(NonEmptyString.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly =
    zio.aws.inspector2.model.AwsEcrContainerImageDetails.wrap(buildAwsValue())
}
object AwsEcrContainerImageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.AwsEcrContainerImageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.AwsEcrContainerImageDetails =
      zio.aws.inspector2.model.AwsEcrContainerImageDetails(
        architecture.map(value => value),
        author.map(value => value),
        imageHash,
        imageTags.map(value => value),
        platform.map(value => value),
        pushedAt.map(value => value),
        registry,
        repositoryName
      )
    def architecture: Optional[NonEmptyString]
    def author: Optional[String]
    def imageHash: ImageHash
    def imageTags: Optional[List[NonEmptyString]]
    def platform: Optional[Platform]
    def pushedAt: Optional[DateTimeTimestamp]
    def registry: NonEmptyString
    def repositoryName: NonEmptyString
    def getArchitecture: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getAuthor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("author", author)
    def getImageHash: ZIO[Any, Nothing, ImageHash] = ZIO.succeed(imageHash)
    def getImageTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("imageTags", imageTags)
    def getPlatform: ZIO[Any, AwsError, Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getPushedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("pushedAt", pushedAt)
    def getRegistry: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(registry)
    def getRepositoryName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerImageDetails
  ) extends zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly {
    override val architecture: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.architecture())
      .map(value => zio.aws.inspector2.model.primitives.NonEmptyString(value))
    override val author: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.author())
      .map(value => value: String)
    override val imageHash: ImageHash =
      zio.aws.inspector2.model.primitives.ImageHash(impl.imageHash())
    override val imageTags: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.inspector2.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val platform: Optional[Platform] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => zio.aws.inspector2.model.primitives.Platform(value))
    override val pushedAt: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.pushedAt())
      .map(value =>
        zio.aws.inspector2.model.primitives.DateTimeTimestamp(value)
      )
    override val registry: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.registry())
    override val repositoryName: NonEmptyString =
      zio.aws.inspector2.model.primitives.NonEmptyString(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.AwsEcrContainerImageDetails
  ): zio.aws.inspector2.model.AwsEcrContainerImageDetails.ReadOnly =
    new Wrapper(impl)
}
