package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PackageFilter(
    architecture: Optional[zio.aws.inspector2.model.StringFilter] =
      Optional.Absent,
    epoch: Optional[zio.aws.inspector2.model.NumberFilter] = Optional.Absent,
    name: Optional[zio.aws.inspector2.model.StringFilter] = Optional.Absent,
    release: Optional[zio.aws.inspector2.model.StringFilter] = Optional.Absent,
    sourceLayerHash: Optional[zio.aws.inspector2.model.StringFilter] =
      Optional.Absent,
    version: Optional[zio.aws.inspector2.model.StringFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.PackageFilter = {
    import PackageFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.PackageFilter
      .builder()
      .optionallyWith(architecture.map(value => value.buildAwsValue()))(
        _.architecture
      )
      .optionallyWith(epoch.map(value => value.buildAwsValue()))(_.epoch)
      .optionallyWith(name.map(value => value.buildAwsValue()))(_.name)
      .optionallyWith(release.map(value => value.buildAwsValue()))(_.release)
      .optionallyWith(sourceLayerHash.map(value => value.buildAwsValue()))(
        _.sourceLayerHash
      )
      .optionallyWith(version.map(value => value.buildAwsValue()))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.PackageFilter.ReadOnly =
    zio.aws.inspector2.model.PackageFilter.wrap(buildAwsValue())
}
object PackageFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.PackageFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.PackageFilter =
      zio.aws.inspector2.model.PackageFilter(
        architecture.map(value => value.asEditable),
        epoch.map(value => value.asEditable),
        name.map(value => value.asEditable),
        release.map(value => value.asEditable),
        sourceLayerHash.map(value => value.asEditable),
        version.map(value => value.asEditable)
      )
    def architecture: Optional[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def epoch: Optional[zio.aws.inspector2.model.NumberFilter.ReadOnly]
    def name: Optional[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def release: Optional[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def sourceLayerHash
        : Optional[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def version: Optional[zio.aws.inspector2.model.StringFilter.ReadOnly]
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getEpoch
        : ZIO[Any, AwsError, zio.aws.inspector2.model.NumberFilter.ReadOnly] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getName
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("name", name)
    def getRelease
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("release", release)
    def getSourceLayerHash
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("sourceLayerHash", sourceLayerHash)
    def getVersion
        : ZIO[Any, AwsError, zio.aws.inspector2.model.StringFilter.ReadOnly] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.PackageFilter
  ) extends zio.aws.inspector2.model.PackageFilter.ReadOnly {
    override val architecture
        : Optional[zio.aws.inspector2.model.StringFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val epoch
        : Optional[zio.aws.inspector2.model.NumberFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.epoch())
        .map(value => zio.aws.inspector2.model.NumberFilter.wrap(value))
    override val name
        : Optional[zio.aws.inspector2.model.StringFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val release
        : Optional[zio.aws.inspector2.model.StringFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.release())
        .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val sourceLayerHash
        : Optional[zio.aws.inspector2.model.StringFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLayerHash())
        .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
    override val version
        : Optional[zio.aws.inspector2.model.StringFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value => zio.aws.inspector2.model.StringFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.PackageFilter
  ): zio.aws.inspector2.model.PackageFilter.ReadOnly = new Wrapper(impl)
}
