package zio.aws.inspector2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.inspector2.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class FreeTrialInfo(
    end: Timestamp,
    start: Timestamp,
    status: zio.aws.inspector2.model.FreeTrialStatus,
    `type`: zio.aws.inspector2.model.FreeTrialType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.inspector2.model.FreeTrialInfo = {
    import FreeTrialInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.inspector2.model.FreeTrialInfo
      .builder()
      .end(Timestamp.unwrap(end): Instant)
      .start(Timestamp.unwrap(start): Instant)
      .status(status.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.inspector2.model.FreeTrialInfo.ReadOnly =
    zio.aws.inspector2.model.FreeTrialInfo.wrap(buildAwsValue())
}
object FreeTrialInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.inspector2.model.FreeTrialInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.inspector2.model.FreeTrialInfo =
      zio.aws.inspector2.model.FreeTrialInfo(end, start, status, `type`)
    def end: Timestamp
    def start: Timestamp
    def status: zio.aws.inspector2.model.FreeTrialStatus
    def `type`: zio.aws.inspector2.model.FreeTrialType
    def getEnd: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(end)
    def getStart: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(start)
    def getStatus: ZIO[Any, Nothing, zio.aws.inspector2.model.FreeTrialStatus] =
      ZIO.succeed(status)
    def getType: ZIO[Any, Nothing, zio.aws.inspector2.model.FreeTrialType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.inspector2.model.FreeTrialInfo
  ) extends zio.aws.inspector2.model.FreeTrialInfo.ReadOnly {
    override val end: Timestamp =
      zio.aws.inspector2.model.primitives.Timestamp(impl.end())
    override val start: Timestamp =
      zio.aws.inspector2.model.primitives.Timestamp(impl.start())
    override val status: zio.aws.inspector2.model.FreeTrialStatus =
      zio.aws.inspector2.model.FreeTrialStatus.wrap(impl.status())
    override val `type`: zio.aws.inspector2.model.FreeTrialType =
      zio.aws.inspector2.model.FreeTrialType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.inspector2.model.FreeTrialInfo
  ): zio.aws.inspector2.model.FreeTrialInfo.ReadOnly = new Wrapper(impl)
}
