package zio.aws.inspector2.model
import scala.jdk.CollectionConverters.*
sealed trait Ec2InstanceSortBy {
  def unwrap: software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy
}
object Ec2InstanceSortBy {
  def wrap(
      value: software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy
  ): zio.aws.inspector2.model.Ec2InstanceSortBy = value match {
    case software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.NETWORK_FINDINGS =>
      val r = NETWORK_FINDINGS
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.inspector2.model.Ec2InstanceSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy =
      software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object NETWORK_FINDINGS
      extends zio.aws.inspector2.model.Ec2InstanceSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy =
      software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.NETWORK_FINDINGS
  }
  case object CRITICAL extends zio.aws.inspector2.model.Ec2InstanceSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy =
      software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.CRITICAL
  }
  case object HIGH extends zio.aws.inspector2.model.Ec2InstanceSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy =
      software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.HIGH
  }
  case object ALL extends zio.aws.inspector2.model.Ec2InstanceSortBy {
    override def unwrap
        : software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy =
      software.amazon.awssdk.services.inspector2.model.Ec2InstanceSortBy.ALL
  }
}
